/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.MobEffectModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;

public class BuffetedOverlay {
    private static final ResourceLocation TEXTURE = YungsCaveBiomesCommon.id("textures/overlay/buffeted_overlay.png");
    private static final int MAX_TICKS = 200;
    private static final float MAX_OPACITY = 1.0f;
    private static final float MIN_COLOR = 0.1f;
    private static final float MAX_COLOR = 0.9f;
    private static int ticks;
    private static float color;

    public static void render(float partialTicks, int screenWidth, int screenHeight) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        if (!client.f_91074_.m_6084_()) {
            ticks = 0;
        }
        int n = ticks = client.f_91074_.m_21023_((MobEffect)MobEffectModule.BUFFETED_EFFECT.get()) ? Math.min(ticks + 1, 200) : Math.max(ticks - 1, 0);
        if (!client.f_91074_.m_5833_() && ticks > 0) {
            float opacity = Mth.m_14036_((float)((float)ticks / 200.0f), (float)0.0f, (float)1.0f);
            int packedLight = client.m_91290_().m_114394_((Entity)client.f_91074_, partialTicks);
            int worldLight = Mth.m_14045_((int)Math.max(LightTexture.m_109883_((int)packedLight), LightTexture.m_109894_((int)packedLight)), (int)0, (int)15);
            int currLight = (int)(color * 16.0f);
            int colorDiff = worldLight - currLight;
            color += 0.003f * (float)colorDiff;
            color = Mth.m_14036_((float)color, (float)0.1f, (float)0.9f);
            BuffetedOverlay.renderOverlay(opacity, screenWidth, screenHeight, color);
        }
    }

    private static void renderOverlay(float opacity, int screenWidth, int screenHeight, float color) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)opacity);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        color = 0.5f;
    }
}

