/*
 * Decompiled with CFR 0.152.
 */
package net.vastless.create_magics.block.custom.mana_storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.vastless.create_magics.block.custom.mana_storage.ManaStorageBlockEntity;
import net.vastless.create_magics.item.ModItems;

public class ManaStorageRenderer
implements BlockEntityRenderer<ManaStorageBlockEntity> {
    private static final float[][] CRYSTAL_TRANSFORMS = new float[][]{{0.5f, 0.7f, 0.5f, 0.5f, 0.2f, 0.5f, 180.0f, 0.0f, 0.0f, 1.0f}, {0.47f, 0.375f, 0.63f, 0.47f, 0.075f, 0.778f, 157.5f, 0.0f, 0.0f, 0.6666667f}, {0.53f, 0.375f, 0.37f, 0.53f, 0.075f, 0.222f, 202.5f, 0.0f, 0.0f, 0.6666667f}, {0.37f, 0.375f, 0.47f, 0.222f, 0.075f, 0.47f, 180.0f, 0.0f, 22.5f, 0.6666667f}, {0.63f, 0.375f, 0.53f, 0.778f, 0.075f, 0.53f, 180.0f, 0.0f, -22.5f, 0.6666667f}};

    public ManaStorageRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ManaStorageBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack crystalStack = new ItemStack((ItemLike)ModItems.CRYSTAL_ITEM.get());
        int light = this.getLightLevel(entity.m_58904_(), entity.m_58899_());
        int[] result = this.calculateCrystals(entity.getMana(), entity.getMaxMana());
        int crystalsToRender = result[0];
        float lastScaleFactor = Float.intBitsToFloat(result[1]);
        for (int i = 0; i < crystalsToRender; ++i) {
            float scale = CRYSTAL_TRANSFORMS[i][9];
            if (i == crystalsToRender - 1) {
                scale *= lastScaleFactor;
            }
            float lerpFactor = scale / CRYSTAL_TRANSFORMS[i][9];
            float px = CRYSTAL_TRANSFORMS[i][0] + (CRYSTAL_TRANSFORMS[i][3] - CRYSTAL_TRANSFORMS[i][0]) * lerpFactor;
            float py = CRYSTAL_TRANSFORMS[i][1] + (CRYSTAL_TRANSFORMS[i][4] - CRYSTAL_TRANSFORMS[i][1]) * lerpFactor;
            float pz = CRYSTAL_TRANSFORMS[i][2] + (CRYSTAL_TRANSFORMS[i][5] - CRYSTAL_TRANSFORMS[i][2]) * lerpFactor;
            this.renderCrystal(crystalStack, poseStack, bufferSource, entity.m_58904_(), entity.m_58899_(), px, py, pz, CRYSTAL_TRANSFORMS[i][6], CRYSTAL_TRANSFORMS[i][7], CRYSTAL_TRANSFORMS[i][8], scale, light);
        }
    }

    private int[] calculateCrystals(float currentMana, float maxMana) {
        float halfMax = maxMana / 2.0f;
        if (currentMana <= halfMax) {
            float factor = currentMana / halfMax;
            return new int[]{1, Float.floatToIntBits(factor)};
        }
        float remaining = currentMana - halfMax;
        float segment = halfMax / 4.0f;
        int fullCrystals = (int)(remaining / segment);
        fullCrystals = Math.min(fullCrystals, 4);
        float lastScale = remaining % segment / segment;
        boolean hasPartial = lastScale > 0.0f && fullCrystals < 4;
        int crystalsToRender = 1 + fullCrystals + (hasPartial ? 1 : 0);
        if (!hasPartial) {
            lastScale = 1.0f;
        }
        return new int[]{crystalsToRender, Float.floatToIntBits(lastScale)};
    }

    private void renderCrystal(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, Level level, BlockPos pos, float px, float py, float pz, float rotX, float rotY, float rotZ, float scale, int light) {
        poseStack.m_85836_();
        poseStack.m_252880_(px, py, pz);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotZ));
        poseStack.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, poseStack, bufferSource, level, 1);
        poseStack.m_85849_();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }
}

