/*
 * Decompiled with CFR 0.152.
 */
package net.vastless.create_magics.block.custom.mana_powered_motor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.vastless.create_magics.IManaStorage;
import net.vastless.create_magics.Utils.Utils;
import net.vastless.create_magics.block.ModBlocks;
import net.vastless.create_magics.block.custom.mana_powered_motor.ManaPoweredMotorBlock;

public class ManaPoweredMotorBlockEntity
extends GeneratingKineticBlockEntity
implements IManaStorage {
    private String spacing = "   ";
    protected ScrollValueBehaviour generatedSpeed;
    private boolean cc_update_rpm = false;
    private int cc_new_rpm = 32;
    private boolean active = false;
    private float Mana = 0.0f;
    private static final float MaxMana = 200.0f;
    private static final float BASE_MANA_CONSUMPTION = 0.2f;
    private static final float MAX_STRESS = 8192.0f;
    private static final float MANA_FETCHING_SPEED = 16.0f;
    int cc_antiSpam = 0;
    boolean first = true;

    private Direction getMappedDirection(Direction toMap) {
        if (toMap == Direction.SOUTH) {
            return Direction.WEST;
        }
        if (toMap == Direction.NORTH) {
            return Direction.EAST;
        }
        if (toMap == Direction.WEST) {
            return Direction.SOUTH;
        }
        if (toMap == Direction.EAST) {
            return Direction.NORTH;
        }
        if (toMap == Direction.UP) {
            return Direction.WEST;
        }
        if (toMap == Direction.DOWN) {
            return Direction.EAST;
        }
        return null;
    }

    public ManaPoweredMotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> side == this.getMappedDirection((Direction)motor.m_61143_((Property)ManaPoweredMotorBlock.FACING)));
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)Component.m_237115_((String)"create.generic.speed"), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-256, 256);
        this.generatedSpeed.value = 32;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        float speed = Math.abs(this.generatedSpeed.getValue());
        float step = 32.0f;
        this.capacity = capacity = Math.max(512.0f, Math.min(8192.0f, -step + 8192.0f)) / speed;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)this.spacing).m_7220_((Component)Component.m_237115_((String)("Mana: " + String.format("%.2f", Float.valueOf(this.Mana)) + "/200.0")).m_130940_(ChatFormatting.AQUA)));
        return true;
    }

    public void updateGeneratedRotation(int i) {
        super.updateGeneratedRotation();
        this.calculateAddedStressCapacity();
        this.cc_new_rpm = i;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    protected Block getStressConfigKey() {
        return (Block)AllBlocks.WATER_WHEEL.get();
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.active = compound.m_128471_("active");
        this.Mana = compound.m_128457_("manaStored");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("active", this.active);
        compound.m_128350_("manaStored", this.Mana);
    }

    public void lazyTick() {
        super.lazyTick();
        this.cc_antiSpam = 5;
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm && this.cc_antiSpam > 0) {
            this.generatedSpeed.setValue(this.cc_new_rpm);
            this.cc_update_rpm = false;
            --this.cc_antiSpam;
            this.updateGeneratedRotation();
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        List<IManaStorage> adjacentStorages = Utils.HasManaStorageBlockAround(this.f_58857_, this.m_58899_());
        if (!adjacentStorages.isEmpty()) {
            float amountToFetch = 16.0f;
            float motorMana = this.getMana();
            float motorMaxMana = this.getMaxMana();
            if ((amountToFetch = Math.min(amountToFetch, motorMaxMana - motorMana)) <= 0.0f) {
                return;
            }
            float amountPerStorage = amountToFetch / (float)adjacentStorages.size();
            for (IManaStorage adjacentStorage : adjacentStorages) {
                float storageMana = adjacentStorage.getMana();
                float remainedToFill = motorMaxMana - motorMana;
                float manaToFetch = Math.min(amountPerStorage, Math.min(storageMana, remainedToFill));
                if ((manaToFetch = Math.max(manaToFetch, 0.0f)) > 0.0f && manaToFetch <= storageMana) {
                    adjacentStorage.subMana(manaToFetch);
                    this.addMana(manaToFetch);
                }
                if (!(this.getMana() >= this.getMaxMana())) continue;
                break;
            }
        }
        if (this.Mana > 0.0f) {
            float speed = Math.abs(this.generatedSpeed.getValue());
            float manaConsumption = 0.2f * (speed / 32.0f);
            if (!this.active) {
                if (this.Mana >= manaConsumption) {
                    this.active = true;
                    this.updateGeneratedRotation();
                }
            } else if (this.Mana >= manaConsumption) {
                this.Mana -= manaConsumption;
                this.updateGeneratedRotation();
            } else {
                this.active = false;
                this.updateGeneratedRotation();
            }
        } else if (this.active) {
            this.active = false;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!ModBlocks.MANA_POWERED_MOTOR.has(this.m_58900_())) {
            return 0.0f;
        }
        return ManaPoweredMotorBlockEntity.convertToDirection((float)(this.active ? (float)this.generatedSpeed.getValue() : 0.0f), (Direction)((Direction)this.m_58900_().m_61143_((Property)ManaPoweredMotorBlock.FACING)));
    }

    public static int getDurationAngle(int deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (int)((double)((1.0f - initialProgress) * (float)deg) / degreesPerTick + 1.0);
    }

    public static int getDurationDistance(int dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0;
        }
        double metersPerTick = speed / 512.0f;
        return (int)((double)((1.0f - initialProgress) * (float)dis) / metersPerTick);
    }

    public boolean setRPM(int rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, 256), -256);
        this.cc_update_rpm = true;
        return this.cc_antiSpam > 0;
    }

    public int getRPM() {
        return this.cc_new_rpm;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    @Override
    public float getMana() {
        return this.Mana;
    }

    @Override
    public float getMaxMana() {
        return 200.0f;
    }

    @Override
    public void setMana(float amount) {
        this.Mana = Math.max(0.0f, Math.min(200.0f, amount));
    }

    @Override
    public void addMana(float amount) {
        this.setMana(this.Mana + amount);
    }

    @Override
    public void subMana(float amount) {
        this.setMana(this.Mana - amount);
    }

    @Override
    public boolean canReceiveMana(int amount) {
        return this.getMana() + (float)amount < this.getMaxMana();
    }

    @Override
    public boolean isConsumer() {
        return true;
    }
}

