/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator.instructions;

public abstract class InstructionResult {
    private final boolean immediateExecution;

    public InstructionResult(boolean immediateExecution) {
        this.immediateExecution = immediateExecution;
    }

    public boolean isImmediate() {
        return this.immediateExecution;
    }

    public abstract int getNextInstruction(int var1);

    public static InstructionResult incomplete() {
        return new ContinueCurrent(false);
    }

    public static InstructionResult next(boolean immediate) {
        return new NextInstruction(immediate);
    }

    public static InstructionResult backToTop(boolean immediate) {
        return new BackToTop(immediate);
    }

    public static InstructionResult terminate() {
        return new EndSequence();
    }

    public static class ContinueCurrent
    extends InstructionResult {
        public ContinueCurrent(boolean immediateExecution) {
            super(immediateExecution);
        }

        @Override
        public int getNextInstruction(int currentInstruction) {
            return currentInstruction;
        }
    }

    public static class NextInstruction
    extends InstructionResult {
        public NextInstruction(boolean immediateExecution) {
            super(immediateExecution);
        }

        @Override
        public int getNextInstruction(int currentInstruction) {
            return currentInstruction + 1;
        }
    }

    public static class BackToTop
    extends InstructionResult {
        public BackToTop(boolean immediateExecution) {
            super(immediateExecution);
        }

        @Override
        public int getNextInstruction(int currentInstruction) {
            return 0;
        }
    }

    public static class EndSequence
    extends InstructionResult {
        public EndSequence() {
            super(false);
        }

        @Override
        public int getNextInstruction(int currentInstruction) {
            return -1;
        }
    }
}

