/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3616;
import net.minecraft.class_3619;
import net.minecraft.class_5819;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlantLike;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class BlocksHelper {
    private static final Map<class_2248, Integer> COLOR_BY_BLOCK = Maps.newHashMap();
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 18;
    public static final int SET_OBSERV = 3;
    public static final class_2350[] HORIZONTAL = BlocksHelper.makeHorizontal();
    public static final class_2350[] DIRECTIONS = class_2350.values();
    private static final ThreadLocal<class_2338.class_2339> TL_POS = ThreadLocal.withInitial(() -> new class_2338.class_2339());
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();
    protected static final class_2680 WATER = class_2246.field_10382.method_9564();

    public static void addBlockColor(class_2248 block, int color) {
        COLOR_BY_BLOCK.put(block, color);
    }

    public static int getBlockColor(class_2248 block) {
        return COLOR_BY_BLOCK.getOrDefault(block, -16777216);
    }

    public static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 18);
    }

    public static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 18);
    }

    public static void setWithUpdate(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 3);
    }

    public static void setWithUpdate(class_1936 world, class_2338 pos, class_2248 block) {
        world.method_8652(pos, block.method_9564(), 3);
    }

    public static int upRay(class_1936 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10086(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(class_1936 world, class_2338 pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.method_22347(pos.method_10087(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(class_1936 world, class_2338 pos, int maxDist) {
        class_2338.class_2339 POS = TL_POS.get();
        POS.method_10101((class_2382)pos);
        for (int j = 1; j < maxDist && world.method_8320((class_2338)POS).method_45474(); ++j) {
            POS.method_33098(POS.method_10264() - 1);
        }
        return pos.method_10264() - POS.method_10264();
    }

    public static int raycastSqr(class_1936 world, class_2338 pos, int dx, int dy, int dz, int maxDist) {
        class_2338.class_2339 POS = TL_POS.get();
        POS.method_10101((class_2382)pos);
        for (int j = 1; j < maxDist && world.method_8320((class_2338)POS).method_45474(); ++j) {
            POS.method_10100(dx, dy, dz);
        }
        return (int)pos.method_10262((class_2382)POS);
    }

    public static class_2680 rotateHorizontal(class_2680 state, class_2470 rotation, class_2769<class_2350> facing) {
        return (class_2680)state.method_11657(facing, (Comparable)rotation.method_10503((class_2350)state.method_11654(facing)));
    }

    public static class_2680 mirrorHorizontal(class_2680 state, class_2415 mirror, class_2769<class_2350> facing) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(facing)));
    }

    public static int getLengthDown(class_1936 world, class_2338 pos, class_2248 block) {
        int count = 1;
        while (world.method_8320(pos.method_10087(count)).method_26204() == block) {
            ++count;
        }
        return count;
    }

    public static class_2350[] makeHorizontal() {
        return new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    }

    public static class_2350 randomHorizontal(class_5819 random) {
        return HORIZONTAL[random.method_43048(4)];
    }

    public static class_2350 randomDirection(class_5819 random) {
        return DIRECTIONS[random.method_43048(6)];
    }

    public static boolean isInvulnerable(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_26214(world, pos) < 0.0f;
    }

    public static boolean isInvulnerableUnsafe(class_2680 state) {
        try {
            return BlocksHelper.isInvulnerable(state, null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<class_2338> findSurfaceBelow(class_1936 level, class_2338 startPos, int minY, Predicate<class_2680> surface) {
        class_2338.class_2339 POS = new class_2338.class_2339(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
        for (int y = startPos.method_10264(); y >= minY; --y) {
            POS.method_33098(y);
            if (!surface.test(level.method_8320((class_2338)POS))) continue;
            return Optional.of(POS);
        }
        return Optional.empty();
    }

    public static boolean findSurface(class_1936 level, class_2338.class_2339 startPos, class_2350 dir, int length, Predicate<class_2680> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.method_8320((class_2338)startPos))) {
                return true;
            }
            startPos.method_10104(dir, 1);
        }
        return false;
    }

    public static boolean findOnSurroundingSurface(class_1936 level, class_2338.class_2339 startPos, class_2350 dir, int length, Predicate<class_2680> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.method_8320((class_2338)startPos))) {
                if (len == 0) {
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.method_10104(dir, -1);
                        if (surface.test(level.method_8320((class_2338)startPos))) continue;
                        return true;
                    }
                    return false;
                }
                startPos.method_10104(dir, -1);
                return true;
            }
            startPos.method_10104(dir, 1);
        }
        return false;
    }

    public static boolean findSurroundingSurface(class_1936 level, class_2338.class_2339 startPos, class_2350 dir, int length, Predicate<class_2680> surface) {
        class_2680 beforeState = null;
        for (int len = 0; len < length; ++len) {
            class_2680 nowState = level.method_8320((class_2338)startPos);
            if (surface.test(nowState)) {
                if (len == 0) {
                    beforeState = nowState;
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.method_10104(dir, -1);
                        nowState = level.method_8320((class_2338)startPos);
                        if (BlocksHelper.isFree(nowState)) {
                            return surface.test(beforeState);
                        }
                        beforeState = nowState;
                    }
                    return false;
                }
                startPos.method_10104(dir, -1);
                return BlocksHelper.isFree(beforeState);
            }
            beforeState = nowState;
            startPos.method_10104(dir, 1);
        }
        return false;
    }

    public static boolean isFreeSpace(class_1936 level, class_2338 startPos, class_2350 dir, int length, Predicate<class_2680> freeSurface) {
        class_2338.class_2339 POS = startPos.method_25503();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.method_8320((class_2338)POS))) {
                return false;
            }
            POS.method_10104(dir, 1);
        }
        return true;
    }

    public static int blockCount(class_1936 level, class_2338 startPos, class_2350 dir, int length, Predicate<class_2680> freeSurface) {
        class_2338.class_2339 POS = startPos.method_25503();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.method_8320((class_2338)POS))) {
                return len;
            }
            POS.method_10104(dir, 1);
        }
        return length;
    }

    public static boolean isLava(class_2680 state) {
        return state.method_26227().method_15772() instanceof class_3616;
    }

    public static boolean isFluid(class_2680 state) {
        return state.method_51176();
    }

    public static boolean isFree(class_2680 state) {
        return state.method_26215();
    }

    public static boolean isFreeOrReplaceable(class_2680 state) {
        return state.method_26215() || state.method_45474();
    }

    public static boolean isFreeOrFluid(class_2680 state) {
        return state.method_26215() || BlocksHelper.isFluid(state);
    }

    public static boolean isTerrain(class_2680 state) {
        return state.method_26164(CommonBlockTags.TERRAIN);
    }

    public static boolean isTerrainOrFluid(class_2680 state) {
        return state.method_26164(CommonBlockTags.TERRAIN) || BlocksHelper.isFluid(state);
    }

    public static Boolean replaceableOrPlant(class_2680 state) {
        class_2248 block = state.method_26204();
        if (state.method_26164(CommonBlockTags.PLANT) || state.method_26164(CommonBlockTags.WATER_PLANT) || block instanceof BehaviourPlantLike) {
            return true;
        }
        if (state.method_26223() == class_3619.field_15971 && block.method_36555() == 0.0f) {
            return true;
        }
        if (state.method_26231() == class_2498.field_11535 || state.method_26231() == class_2498.field_11534 || state.method_26231() == class_2498.field_17580 || state.method_26231() == class_2498.field_28692) {
            return true;
        }
        return state.method_45474();
    }

    public static void forAllInBounds(class_3341 bb, Consumer<class_2338> worker) {
        for (int x = bb.method_35415(); x <= bb.method_35418(); ++x) {
            for (int y = bb.method_35416(); y <= bb.method_35419(); ++y) {
                for (int z = bb.method_35417(); z <= bb.method_35420(); ++z) {
                    class_2338 bp = new class_2338(x, y, z);
                    worker.accept(bp);
                }
            }
        }
    }

    public static void forOutlineInBounds(class_3341 bb, Consumer<class_2338> worker) {
        for (int x = bb.method_35415(); x <= bb.method_35418(); ++x) {
            worker.accept(new class_2338(x, bb.method_35416(), bb.method_35417()));
            worker.accept(new class_2338(x, bb.method_35419(), bb.method_35417()));
            worker.accept(new class_2338(x, bb.method_35416(), bb.method_35420()));
            worker.accept(new class_2338(x, bb.method_35419(), bb.method_35420()));
        }
        for (int y = bb.method_35416(); y <= bb.method_35419(); ++y) {
            worker.accept(new class_2338(bb.method_35415(), y, bb.method_35417()));
            worker.accept(new class_2338(bb.method_35418(), y, bb.method_35417()));
            worker.accept(new class_2338(bb.method_35415(), y, bb.method_35420()));
            worker.accept(new class_2338(bb.method_35418(), y, bb.method_35420()));
        }
        for (int z = bb.method_35417(); z <= bb.method_35420(); ++z) {
            worker.accept(new class_2338(bb.method_35415(), bb.method_35416(), z));
            worker.accept(new class_2338(bb.method_35418(), bb.method_35416(), z));
            worker.accept(new class_2338(bb.method_35415(), bb.method_35419(), z));
            worker.accept(new class_2338(bb.method_35418(), bb.method_35419(), z));
        }
    }
}

