/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record SkullStats(int durability, int armor) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("skull"));
    public static final MaterialStatType<SkullStats> TYPE = new MaterialStatType<SkullStats>(ID, new SkullStats(1, 0), RecordLoadable.create(IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)IntLoadable.FROM_ZERO.defaultField("armor", (Object)0, true, SkullStats::armor), SkullStats::new));
    private static final List<Component> DESCRIPTION = List.of(ToolStats.DURABILITY.getDescription(), ToolStats.ARMOR.getDescription());

    @Override
    public MaterialStatType<?> getType() {
        return TYPE;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        return List.of(ToolStats.DURABILITY.formatValue(this.durability), ToolStats.ARMOR.formatValue(this.armor));
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        ToolStats.ARMOR.update(builder, Float.valueOf((float)this.armor * scale));
    }
}

