/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.CureOnRemovalModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class StrongBonesModifier
extends NoLevelsModifier {
    public static final TinkerDataCapability.TinkerDataKey<Integer> CALCIFIABLE = TConstruct.createKey("calcifable");
    public static final ArmorLevelModule CALCIFIABLE_MODULE = new ArmorLevelModule(CALCIFIABLE, false, TinkerTags.Items.HELD_ARMOR);
    public static final FluidEffect<FluidEffectContext.Entity> FLUID_EFFECT = FluidEffect.simple((fluid, scale, context, action) -> {
        LivingEntity target = context.getLivingTarget();
        if (target != null && StrongBonesModifier.drinkMilk(target, (int)(200.0f * scale.value()), action)) {
            return scale.value();
        }
        return 0.0f;
    });

    public StrongBonesModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEntityUseItemEvent.Finish.class, StrongBonesModifier::onItemFinishUse);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(CureOnRemovalModule.HELMET);
    }

    private static boolean drinkMilk(LivingEntity living, int duration, IFluidHandler.FluidAction action) {
        MobEffectInstance effect;
        ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
        boolean didSomething = false;
        if (ModifierUtil.getModifierLevel(helmet, TinkerModifiers.strongBones.getId()) > 0) {
            effect = new MobEffectInstance(MobEffects.f_19606_, duration);
            effect.getCurativeItems().clear();
            effect.getCurativeItems().add(new ItemStack((ItemLike)helmet.m_41720_()));
            boolean bl = didSomething = action.execute() ? living.m_7292_(effect) : living.m_7301_(effect);
            if (didSomething && action.simulate()) {
                return true;
            }
        }
        if (ArmorLevelModule.getLevel(living, CALCIFIABLE) > 0) {
            effect = new MobEffectInstance((MobEffect)TinkerModifiers.calcifiedEffect.get(), duration, 0);
            didSomething |= action.execute() ? living.m_7292_(effect) : living.m_7301_(effect);
        }
        return didSomething;
    }

    private static void onItemFinishUse(LivingEntityUseItemEvent.Finish event) {
        LivingEntity living = event.getEntity();
        if (event.getItem().m_41720_() == Items.f_42455_) {
            StrongBonesModifier.drinkMilk(living, 1200, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

