/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.IdParser;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.command.argument.TinkerSuggestionProvider;

public class MaterialStatsArgument
implements ArgumentType<MaterialStatType<?>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("tconstruct:head", "tconstruct:limb");
    private static final DynamicCommandExceptionType MODIFIER_NOT_FOUND = new DynamicCommandExceptionType(name -> TConstruct.makeTranslation("command", "material_stat.not_found", name));

    public MaterialStatType<?> parse(StringReader reader) throws CommandSyntaxException {
        MaterialStatsId loc = new MaterialStatsId(IdParser.read("tconstruct", reader));
        MaterialStatType statType = MaterialRegistry.getInstance().getStatType(loc);
        if (statType == null) {
            throw MODIFIER_NOT_FOUND.create((Object)loc);
        }
        return statType;
    }

    public static MaterialStatType<?> getStat(CommandContext<CommandSourceStack> context, String name) {
        return (MaterialStatType)context.getArgument(name, MaterialStatType.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return TinkerSuggestionProvider.suggestResource("tconstruct", MaterialRegistry.getInstance().getAllStatTypeIds(), builder, id -> id, id -> Util.makeTranslation("stat", id, new Object[0]));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private MaterialStatsArgument() {
    }

    public static MaterialStatsArgument stats() {
        return new MaterialStatsArgument();
    }
}

