/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MeltingFuelHandler {
    private static List<Pair<Integer, List<FluidStack>>> fuelLookup = Collections.emptyList();
    public static final Lazy<List<ItemStack>> SOLID_FUELS = Lazy.of(() -> Arrays.asList(new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42414_), new ItemStack((ItemLike)Blocks.f_49999_), new ItemStack((ItemLike)Blocks.f_50705_), new ItemStack((ItemLike)Items.f_42585_)));

    public static void setMeltngFuels(List<MeltingFuel> fuels) {
        fuels.sort(Comparator.comparingInt(MeltingFuel::getTemperature));
        fuelLookup = fuels.stream().mapToInt(MeltingFuel::getTemperature).distinct().mapToObj(temperature -> Pair.of((Object)temperature, fuels.stream().filter(fuel -> fuel.getTemperature() >= temperature).flatMap(fuel -> fuel.getInputs().stream()).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public static List<FluidStack> getUsableFuels(int temperature) {
        for (Pair<Integer, List<FluidStack>> pair : fuelLookup) {
            if (temperature > (Integer)pair.getFirst()) continue;
            return (List)pair.getSecond();
        }
        return Collections.emptyList();
    }
}

