/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.handler.codec.EncoderException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record IdParser<T extends ResourceLocation>(Function<String, T> constructor, String name) implements StringLoadable<T>
{
    @Nullable
    public T tryParse(String string) {
        try {
            return (T)((ResourceLocation)this.constructor.apply(string));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    public T parseString(String text, String key, TypedMap context) {
        try {
            return (T)((ResourceLocation)this.constructor.apply(text));
        }
        catch (ResourceLocationException ex) {
            throw new JsonSyntaxException("Expected " + key + " to be a " + this.name + " ID, received invalid characters", (Throwable)ex);
        }
    }

    public String getString(T object) {
        return object.toString();
    }

    public T decode(FriendlyByteBuf buf, TypedMap context) {
        return (T)((ResourceLocation)this.constructor.apply(buf.m_130136_(Short.MAX_VALUE)));
    }

    public void encode(FriendlyByteBuf buffer, T object) throws EncoderException {
        buffer.m_130085_(object);
    }

    public static String[] decompose(String defaultDomain, String location, char separator) {
        String[] parts = new String[]{defaultDomain, location};
        int loc = location.indexOf(separator);
        if (loc >= 0) {
            parts[1] = location.substring(loc + 1);
            if (loc >= 1) {
                parts[0] = location.substring(0, loc);
            }
        }
        return parts;
    }

    public static String[] decompose(String defaultDomain, String location) {
        return IdParser.decompose(defaultDomain, location, ':');
    }

    public static ResourceLocation read(String defaultDomain, StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_((char)reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(start, reader.getCursor());
        String[] parts = IdParser.decompose(defaultDomain, string);
        try {
            return new ResourceLocation(parts[0], parts[1]);
        }
        catch (ResourceLocationException ex) {
            reader.setCursor(start);
            throw ResourceLocation.f_135806_.createWithContext((ImmutableStringReader)reader);
        }
    }
}

