/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item.armor;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ArmorUtil;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;

public class MultilayerArmorItem
extends ModifiableArmorItem {
    private final ResourceLocation name;

    public MultilayerArmorItem(ModifiableArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
        this.name = material.getId();
    }

    public MultilayerArmorItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties properties, ToolDefinition toolDefinition) {
        super(material, slot, properties, toolDefinition);
        this.name = new ResourceLocation(material.m_6082_());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ArmorUtil.getDummyArmorTexture(slot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new ArmorModelManager.ArmorModelDispatcher(){

            @Override
            protected ResourceLocation getName() {
                return MultilayerArmorItem.this.name;
            }
        });
    }
}

