/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.build;

import java.util.List;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolStatsHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public record SetStatsModule(StatsNBT stats) implements ToolStatsHook,
ToolModule
{
    public static final RecordLoadable<SetStatsModule> LOADER = RecordLoadable.create((RecordField)StatsNBT.LOADABLE.requiredField("stats", SetStatsModule::stats), SetStatsModule::new);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_STATS);

    public RecordLoadable<SetStatsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private <T> void setStat(IToolStat<T> stat, ModifierStatsBuilder builder) {
        stat.update(builder, this.stats.get(stat));
    }

    @Override
    public void addToolStats(IToolContext context, ModifierStatsBuilder builder) {
        for (IToolStat<?> stat : this.stats.getContainedStats()) {
            this.setStat(stat, builder);
        }
    }

    public static ArmorBuilder armor(List<ArmorItem.Type> slots) {
        return new ArmorBuilder(slots);
    }

    public static class ArmorBuilder
    implements ArmorModuleBuilder<SetStatsModule> {
        private final List<ArmorItem.Type> slotTypes;
        private final StatsNBT.Builder[] builders = new StatsNBT.Builder[4];

        private ArmorBuilder(List<ArmorItem.Type> slotTypes) {
            this.slotTypes = slotTypes;
            for (ArmorItem.Type slotType : slotTypes) {
                this.builders[slotType.ordinal()] = StatsNBT.builder();
            }
        }

        protected StatsNBT.Builder getBuilder(ArmorItem.Type slotType) {
            StatsNBT.Builder builder = this.builders[slotType.ordinal()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType);
            }
            return builder;
        }

        public <T> ArmorBuilder set(ArmorItem.Type slotType, IToolStat<T> stat, T value) {
            this.getBuilder(slotType).set(stat, value);
            return this;
        }

        public ArmorBuilder set(ArmorItem.Type slotType, IToolStat<Float> stat, float value) {
            return this.set(slotType, (IToolStat)stat, (Object)Float.valueOf(value));
        }

        public <T> ArmorBuilder setAll(IToolStat<T> stat, T value) {
            for (ArmorItem.Type slotType : this.slotTypes) {
                this.set(slotType, stat, value);
            }
            return this;
        }

        public ArmorBuilder setAll(IToolStat<Float> stat, float value) {
            return this.setAll((IToolStat)stat, (Object)Float.valueOf(value));
        }

        public final ArmorBuilder setInOrder(IToolStat<Float> stat, float ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.set(this.slotTypes.get(i), stat, values[i]);
            }
            return this;
        }

        public ArmorBuilder durabilityFactor(float maxDamageFactor) {
            for (ArmorItem.Type slotType : this.slotTypes) {
                this.set(slotType, ToolStats.DURABILITY, (float)ArmorModuleBuilder.MAX_DAMAGE_ARRAY[slotType.ordinal()] * maxDamageFactor);
            }
            return this;
        }

        @Override
        public SetStatsModule build(ArmorItem.Type slot) {
            return new SetStatsModule(this.getBuilder(slot).build());
        }
    }
}

