/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifierRecipeLookup {
    private static final Multimap<ModifierId, ModifierSalvage> SALVAGE = HashMultimap.create();
    private static final Multimap<SlotType, LazyModifier> RECIPE_MODIFIERS = HashMultimap.create();
    private static final Multimap<SlotType, ModifierId> RECIPE_MODIFIER_IDS = HashMultimap.create();
    private static List<ModifierEntry> RECIPE_MODIFIER_LIST = null;
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        SALVAGE.clear();
        RECIPE_MODIFIERS.clear();
        RECIPE_MODIFIER_IDS.clear();
        RECIPE_MODIFIER_LIST = null;
    });

    public static void addSalvage(ModifierSalvage salvage) {
        LISTENER.checkClear();
        SALVAGE.put((Object)salvage.getModifier(), (Object)salvage);
    }

    @Nullable
    public static ModifierSalvage getSalvage(ItemStack stack, IToolStackView tool, ModifierId modifier, int modifierLevel) {
        for (ModifierSalvage salvage : SALVAGE.get((Object)modifier)) {
            if (!salvage.matches(stack, tool, modifierLevel)) continue;
            return salvage;
        }
        return null;
    }

    public static void addRecipeModifier(@Nullable SlotType slotType, LazyModifier modifier) {
        LISTENER.checkClear();
        RECIPE_MODIFIERS.put((Object)slotType, (Object)modifier);
        RECIPE_MODIFIER_IDS.put((Object)slotType, (Object)modifier.getId());
    }

    public static Stream<Modifier> getAllRecipeModifiers() {
        return RECIPE_MODIFIERS.values().stream().map(LazyModifier::get).distinct();
    }

    public static List<ModifierEntry> getRecipeModifierList() {
        if (RECIPE_MODIFIERS.isEmpty()) {
            return Collections.emptyList();
        }
        if (RECIPE_MODIFIER_LIST == null) {
            RECIPE_MODIFIER_LIST = RECIPE_MODIFIERS.values().stream().distinct().sorted(Comparator.comparing(LazyModifier::getId)).map(mod -> new ModifierEntry((LazyModifier)mod, 1)).toList();
        }
        return RECIPE_MODIFIER_LIST;
    }

    public static Stream<Modifier> getRecipeModifiers(@Nullable SlotType slotType) {
        return RECIPE_MODIFIERS.get((Object)slotType).stream().map(LazyModifier::get);
    }

    public static boolean isRecipeModifier(ModifierId modifier) {
        return RECIPE_MODIFIER_IDS.containsValue((Object)modifier);
    }

    public static boolean isRecipeModifier(@Nullable SlotType slotType, ModifierId modifier) {
        return RECIPE_MODIFIER_IDS.containsEntry((Object)slotType, (Object)modifier);
    }
}

