/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record OffsettingSpriteTransformer(@Nullable ISpriteTransformer base, int xOffset, int yOffset) implements ISpriteTransformer
{
    public static final ResourceLocation NAME = TConstruct.getResource("offsetting");
    public static final JsonDeserializer<OffsettingSpriteTransformer> DESERIALIZER = (element, type, context) -> {
        JsonObject json = element.getAsJsonObject();
        ISpriteTransformer base = null;
        if (json.has("base")) {
            base = (ISpriteTransformer)SERIALIZER.deserialize(json.get("base"), ISpriteTransformer.class, context);
        }
        int xOffset = GsonHelper.m_13824_((JsonObject)json, (String)"x", (int)0);
        int yOffset = GsonHelper.m_13824_((JsonObject)json, (String)"y", (int)0);
        if (xOffset == 0 && yOffset == 0) {
            throw new JsonSyntaxException("Must have offset to use offsetting transformer");
        }
        return new OffsettingSpriteTransformer(base, xOffset, yOffset);
    };

    @Override
    public int getFallbackColor() {
        return this.base != null ? this.base.getFallbackColor() : -1;
    }

    @Override
    public int getFrames() {
        return this.base != null ? this.base.getFrames() : 1;
    }

    @Override
    public void transform(NativeImage image, boolean allowAnimated) {
        if (this.base != null) {
            this.base.transform(image, allowAnimated);
        }
        int width = image.m_84982_();
        int frames = allowAnimated && this.base != null ? this.base.getFrames() : 1;
        int height = image.m_85084_() / frames;
        for (int f = 0; f < frames; ++f) {
            int frameOffset = f * height;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int localX = x;
                    int localY = y;
                    if (this.xOffset > 0) {
                        localX = width - x - 1;
                    }
                    if (this.yOffset > 0) {
                        localY = height - y - 1;
                    }
                    int getX = localX - this.xOffset;
                    int getY = localY - this.yOffset;
                    if (0 <= getX && getX < width && 0 <= getY && getY < height) {
                        image.m_84988_(localX, localY + frameOffset, image.m_84985_(getX, getY));
                        continue;
                    }
                    image.m_84988_(localX, localY + frameOffset, 0);
                }
            }
        }
    }

    @Override
    public NativeImage copyImage(NativeImage image, boolean allowAnimated) {
        return this.base != null ? this.base.copyImage(image, allowAnimated) : ISpriteTransformer.copyImage(image);
    }

    @Override
    @Nullable
    public JsonObject animationMeta(NativeImage image) {
        if (this.base != null) {
            return this.base.animationMeta(image);
        }
        return null;
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(NAME);
        if (this.base != null) {
            json.add("base", (JsonElement)this.base.serialize(context));
        }
        json.addProperty("x", (Number)this.xOffset);
        json.addProperty("y", (Number)this.yOffset);
        return json;
    }
}

