/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.materials.MaterialGeneratorInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public abstract class AbstractMaterialRenderInfoProvider
extends GenericDataProvider {
    private final Map<MaterialVariantId, RenderInfoBuilder> allRenderInfo = new HashMap<MaterialVariantId, RenderInfoBuilder>();
    @Nullable
    private final AbstractMaterialSpriteProvider materialSprites;
    @Nullable
    private final ExistingFileHelper existingFileHelper;

    public AbstractMaterialRenderInfoProvider(PackOutput packOutput, @Nullable AbstractMaterialSpriteProvider materialSprites, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "tinkering/materials");
        this.materialSprites = materialSprites;
        this.existingFileHelper = existingFileHelper;
    }

    public AbstractMaterialRenderInfoProvider(PackOutput packOutput) {
        this(packOutput, null, null);
    }

    protected abstract void addMaterialRenderInfo();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        if (this.existingFileHelper != null) {
            MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        }
        this.addMaterialRenderInfo();
        return AbstractMaterialRenderInfoProvider.allOf(this.allRenderInfo.entrySet().stream().map(entry -> this.saveJson(cache, ((MaterialVariantId)entry.getKey()).getLocation('/'), ((RenderInfoBuilder)entry.getValue()).build((MaterialVariantId)entry.getKey())))).thenRunAsync(() -> {
            if (this.existingFileHelper != null) {
                MaterialPartTextureGenerator.runCallbacks(null, null);
            }
        });
    }

    private RenderInfoBuilder getBuilder(@Nullable ResourceLocation texture) {
        AbstractMaterialSpriteProvider.MaterialSpriteInfo spriteInfo;
        RenderInfoBuilder builder = new RenderInfoBuilder().texture(texture);
        if (this.materialSprites != null && texture != null && (spriteInfo = this.materialSprites.getMaterialInfo(texture)) != null) {
            builder.fallbacks(spriteInfo.getFallbacks());
            int color = spriteInfo.getTransformer().getFallbackColor();
            if (color != -1) {
                builder.color(color & 0xFF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000);
            }
            builder.generator(spriteInfo);
        }
        return builder;
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId) {
        return this.buildRenderInfo(materialId, materialId.getLocation('_'));
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId, @Nullable ResourceLocation texture) {
        return this.allRenderInfo.computeIfAbsent(materialId, id -> this.getBuilder(texture));
    }

    protected RenderInfoBuilder redirect(MaterialVariantId materialId, MaterialVariantId target) {
        return this.buildRenderInfo(materialId, null).parentMaterial(target).texture(target.getLocation('_'));
    }

    @CanIgnoreReturnValue
    protected static class RenderInfoBuilder {
        @Nullable
        private ResourceLocation texture = null;
        @Nullable
        private ResourceLocation parent = null;
        private String[] fallbacks = new String[0];
        private int color = -1;
        private int luminosity = 0;
        private MaterialGeneratorInfo generator = null;

        protected RenderInfoBuilder() {
        }

        public RenderInfoBuilder parentMaterial(MaterialVariantId material) {
            return this.parent(material.getLocation('/'));
        }

        public RenderInfoBuilder color(int color) {
            if ((color & 0xFF000000) == 0) {
                color |= 0xFF000000;
            }
            this.color = color;
            return this;
        }

        public RenderInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public RenderInfoBuilder materialTexture(MaterialVariantId variantId) {
            return this.texture(variantId.getLocation('_'));
        }

        public RenderInfoBuilder skipUniqueTexture() {
            return this.texture(null);
        }

        @CheckReturnValue
        public JsonObject build(MaterialVariantId id) {
            JsonObject json = new JsonObject();
            if (this.parent != null) {
                json.addProperty("parent", this.parent.toString());
            }
            MaterialRenderInfo.LOADABLE.serialize((Object)new MaterialRenderInfo(id, this.texture, this.fallbacks, this.color, this.luminosity), json);
            if (this.generator != null) {
                json.add("generator", MaterialGeneratorInfo.LOADABLE.serialize((Object)this.generator));
            }
            return json;
        }

        public RenderInfoBuilder texture(@Nullable ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public RenderInfoBuilder parent(@Nullable ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public RenderInfoBuilder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public RenderInfoBuilder generator(MaterialGeneratorInfo generator) {
            this.generator = generator;
            return this;
        }
    }
}

