/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentPageIconList;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.FluidEffectContent;
import slimeknights.tconstruct.library.client.book.elements.FluidItemElement;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;

public class FluidEffectInjectingTransformer
extends BookTransformer {
    public static final FluidEffectInjectingTransformer INSTANCE = new FluidEffectInjectingTransformer();
    private static final ResourceLocation KEY = TConstruct.getResource("fluid_effects");

    private FluidEffectInjectingTransformer() {
    }

    private void addPages(SectionData section, JsonElement element) {
        try {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)KEY.toString());
            String path = GsonHelper.m_13906_((JsonObject)json, (String)"path");
            List presorted = (List)StringLoadable.DEFAULT.list(0).getOrDefault(json, "order", List.of());
            List<FluidEffects.Entry> effects = FluidEffectManager.INSTANCE.getFluids();
            if (effects.isEmpty()) {
                return;
            }
            HashMap<ResourceLocation, ContentPageIconList.PageWithIcon> newPages = new HashMap<ResourceLocation, ContentPageIconList.PageWithIcon>();
            for (FluidEffects.Entry entry : effects) {
                FluidEffects effect = entry.effects();
                if (effect.hidden()) continue;
                List fluids = effect.ingredient().getFluids();
                if (fluids.isEmpty()) {
                    return;
                }
                ResourceLocation name = entry.name();
                PageData newPage = new PageData(true);
                newPage.parent = section;
                newPage.source = section.source;
                newPage.type = FluidEffectContent.ID;
                newPage.name = name.m_135827_() + "." + name.m_135815_();
                String data = path + "/" + name.m_135827_() + "_" + name.m_135815_() + ".json";
                if (section.source.resourceExists(section.source.getResourceLocation(data))) {
                    newPage.data = data;
                } else {
                    newPage.content = new FluidEffectContent();
                }
                newPage.load();
                List<ItemStack> displayStacks = FluidItemElement.createItemList(fluids);
                PageContent pageContent = newPage.content;
                if (pageContent instanceof FluidEffectContent) {
                    FluidEffectContent fluidEffectContent = (FluidEffectContent)pageContent;
                    fluidEffectContent.loadEffectData(name, effect, fluids, displayStacks);
                }
                ItemElement icon = new ItemElement(0, 0, 1.0f, displayStacks);
                newPages.put(name, new ContentPageIconList.PageWithIcon((SizedBookElement)icon, newPage));
            }
            List listPages = ContentPageIconList.getPagesNeededForItemCount((int)newPages.size(), (SectionData)section, (String)section.parent.translate(section.name), (String)((String)section.parent.strings.get(String.format("%s.subtext", section.name))));
            ArrayList<ContentPageIconList.PageWithIcon> sortedPages = new ArrayList<ContentPageIconList.PageWithIcon>();
            for (String name : presorted) {
                ContentPageIconList.PageWithIcon page;
                ResourceLocation id = null;
                if (name.contains(":")) {
                    id = ResourceLocation.m_135820_((String)name);
                } else if (ResourceLocation.m_135841_((String)name)) {
                    id = TConstruct.getResource(name);
                }
                if (id == null || (page = (ContentPageIconList.PageWithIcon)newPages.get(id)) == null) continue;
                sortedPages.add(page);
                newPages.remove(id);
            }
            sortedPages.addAll(newPages.values().stream().sorted(Comparator.comparing(pair -> pair.page().getTitle())).toList());
            ContentPageIconList.addPages((SectionData)section, (List)listPages, sortedPages);
        }
        catch (JsonParseException e) {
            TConstruct.LOG.error("Failed to parse tag for book page injecting", (Throwable)e);
        }
    }

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement element = (JsonElement)section.extraData.get(KEY);
            if (element == null) continue;
            this.addPages(section, element);
        }
    }
}

