/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.screenhandlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gui.GuiRadial;
import org.vivecraft.client_vr.provider.ControllerType;

public class RadialHandler {
    public static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    public static GuiRadial UI = new GuiRadial();
    public static RenderTarget FRAMEBUFFER = null;
    public static Vector3f POS_ROOM = new Vector3f();
    public static Matrix4f ROTATION_ROOM = new Matrix4f();
    private static boolean SHOWING = false;
    private static boolean POINTED_L;
    private static boolean POINTED_R;
    private static ControllerType ACTIVE_CONTROLLER;
    private static boolean LAST_PRESSED_CLICK_L;
    private static boolean LAST_PRESSED_CLICK_R;
    private static boolean LAST_PRESSED_SHIFT_L;
    private static boolean LAST_PRESSED_SHIFT_R;

    public static boolean setOverlayShowing(boolean showingState, ControllerType controller) {
        if (RadialHandler.DH.kiosk) {
            return false;
        }
        if (RadialHandler.DH.vrSettings.seated) {
            showingState = false;
        }
        if (showingState) {
            UI.m_6575_(Minecraft.m_91087_(), GuiHandler.SCALED_WIDTH_MAX, GuiHandler.SCALED_HEIGHT_MAX);
            SHOWING = true;
            ACTIVE_CONTROLLER = controller;
            RadialHandler.orientOverlay(ACTIVE_CONTROLLER);
        } else {
            SHOWING = false;
            ACTIVE_CONTROLLER = null;
        }
        return RadialHandler.isShowing();
    }

    public static void processGui() {
        POINTED_L = false;
        POINTED_R = false;
        if (!SHOWING) {
            return;
        }
        if (RadialHandler.DH.vrSettings.seated) {
            return;
        }
        if (ROTATION_ROOM == null) {
            return;
        }
        POINTED_R = UI.processCursor(POS_ROOM, ROTATION_ROOM, false);
        POINTED_L = UI.processCursor(POS_ROOM, ROTATION_ROOM, true);
    }

    public static void orientOverlay(ControllerType controller) {
        if (!RadialHandler.isShowing()) {
            return;
        }
        VRData.VRDevicePose roomPose = RadialHandler.DH.vrPlayer.vrdata_room_pre.hmd;
        float distance = 2.0f;
        int id = 0;
        if (controller == ControllerType.LEFT) {
            id = 1;
        }
        if (RadialHandler.DH.vrSettings.radialModeHold) {
            roomPose = RadialHandler.DH.vrPlayer.vrdata_room_pre.getController(id);
            distance = 1.2f;
        }
        Vector3f position = roomPose.getPositionF();
        Vector3f offset = roomPose.getDirection().mul(distance * 0.5f);
        POS_ROOM = position.add((Vector3fc)offset);
        float pitch = (float)Math.asin(offset.y / offset.length());
        float yaw = (float)Math.PI + (float)Math.atan2(offset.x, offset.z);
        ROTATION_ROOM.rotationY(yaw);
        ROTATION_ROOM.rotateX(pitch);
    }

    public static void processBindings() {
        if (!RadialHandler.isShowing()) {
            return;
        }
        if (POINTED_L && GuiHandler.KEY_KEYBOARD_SHIFT.consumeClick(ControllerType.LEFT)) {
            UI.setShift(true);
            LAST_PRESSED_SHIFT_L = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.isDown(ControllerType.LEFT) && LAST_PRESSED_SHIFT_L) {
            UI.setShift(false);
            LAST_PRESSED_SHIFT_L = false;
        }
        if (POINTED_R && GuiHandler.KEY_KEYBOARD_SHIFT.consumeClick(ControllerType.RIGHT)) {
            UI.setShift(true);
            LAST_PRESSED_SHIFT_R = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.isDown(ControllerType.RIGHT) && LAST_PRESSED_SHIFT_R) {
            UI.setShift(false);
            LAST_PRESSED_SHIFT_R = false;
        }
        float uiScaleX = (float)RadialHandler.UI.f_96543_ / (float)GuiHandler.GUI_WIDTH;
        float uiScaleY = (float)RadialHandler.UI.f_96544_ / (float)GuiHandler.GUI_HEIGHT;
        int x1 = (int)((float)Math.min(Math.max((int)RadialHandler.UI.cursorX1, 0), GuiHandler.GUI_WIDTH) * uiScaleX);
        int y1 = (int)((float)Math.min(Math.max((int)RadialHandler.UI.cursorY1, 0), GuiHandler.GUI_HEIGHT) * uiScaleY);
        int x2 = (int)((float)Math.min(Math.max((int)RadialHandler.UI.cursorX2, 0), GuiHandler.GUI_WIDTH) * uiScaleX);
        int y2 = (int)((float)Math.min(Math.max((int)RadialHandler.UI.cursorY2, 0), GuiHandler.GUI_HEIGHT) * uiScaleY);
        if (RadialHandler.DH.vrSettings.radialModeHold) {
            if (ACTIVE_CONTROLLER == null) {
                return;
            }
            if (!VivecraftVRMod.INSTANCE.keyRadialMenu.m_90857_()) {
                if (ACTIVE_CONTROLLER == ControllerType.LEFT) {
                    UI.m_6375_(x1, y1, 0);
                } else {
                    UI.m_6375_(x2, y2, 0);
                }
                RadialHandler.setOverlayShowing(false, null);
            }
        } else {
            if (POINTED_L && GuiHandler.KEY_KEYBOARD_CLICK.consumeClick(ControllerType.LEFT)) {
                UI.m_6375_(x1, y1, 0);
                LAST_PRESSED_CLICK_L = true;
            }
            if (!GuiHandler.KEY_KEYBOARD_CLICK.isDown(ControllerType.LEFT) && LAST_PRESSED_CLICK_L) {
                UI.m_6348_(x1, y1, 0);
                LAST_PRESSED_CLICK_L = false;
            }
            if (POINTED_R && GuiHandler.KEY_KEYBOARD_CLICK.consumeClick(ControllerType.RIGHT)) {
                UI.m_6375_(x2, y2, 0);
                LAST_PRESSED_CLICK_R = true;
            }
            if (!GuiHandler.KEY_KEYBOARD_CLICK.isDown(ControllerType.RIGHT) && LAST_PRESSED_CLICK_R) {
                UI.m_6348_(x2, y2, 0);
                LAST_PRESSED_CLICK_R = false;
            }
        }
    }

    public static boolean isShowing() {
        return SHOWING;
    }

    public static boolean isUsingController(ControllerType controller) {
        return controller == ControllerType.LEFT ? POINTED_L : POINTED_R;
    }
}

