/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionSlider;
import org.vivecraft.client.gui.framework.widgets.TextOnlyButton;
import org.vivecraft.client.utils.StringSimilarity;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.TooltipUtil;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;

public class SettingsList
extends ContainerObjectSelectionList<BaseEntry> {
    private final List<BaseEntry> allEntries;
    private String activeFilter = "";
    private boolean active = true;
    private final Screen parent;

    public SettingsList(Screen parent, Minecraft minecraft, List<BaseEntry> entries, boolean searchable) {
        super(minecraft, parent.f_96543_, parent.f_96544_, searchable ? 42 : 20, parent.f_96544_ - (searchable ? 74 : 52) + (searchable ? 42 : 20), 20);
        this.parent = parent;
        entries = entries.stream().filter(Objects::nonNull).toList();
        this.allEntries = new ArrayList<BaseEntry>(entries);
        this.replaceEntriesFlatten(this.allEntries);
    }

    public void setActive(boolean active) {
        this.active = active;
        this.allEntries.forEach(entry -> entry.setParentActive(active));
    }

    private void replaceEntriesFlatten(List<BaseEntry> entries) {
        this.replaceEntriesFlatten(entries.stream());
    }

    private void replaceEntriesFlatten(Stream<BaseEntry> entries) {
        this.m_5988_(entries.flatMap(entry -> entry.getEntries().stream()).toList());
    }

    public String getActiveFilter() {
        return this.activeFilter;
    }

    public void filter(String filter) {
        if (ClientDataHolderVR.getInstance().vrSettings.useFuzzySearch) {
            this.fuzzyFilter(filter);
        } else {
            this.exactFilter(filter);
        }
    }

    private void exactFilter(String filter) {
        if (!filter.trim().equals(this.activeFilter)) {
            this.m_93410_(0.0);
            String lowerCase = filter.trim().toLowerCase();
            this.replaceEntriesFlatten(this.allEntries.stream().filter((? super T entry) -> entry.filter(lowerCase)));
        }
        this.activeFilter = filter.trim();
    }

    private void fuzzyFilter(String filter) {
        if (filter.trim().isEmpty()) {
            this.replaceEntriesFlatten(this.allEntries);
        } else if (!filter.trim().equals(this.activeFilter)) {
            this.m_93410_(0.0);
            String lowerCase = filter.trim().toLowerCase();
            List<BaseEntry> entries = this.allEntries.stream().flatMap(child -> child.getEntries().stream()).filter((? super T entry) -> !(entry instanceof CategoryEntry)).map(entry -> Pair.of((Object)Float.valueOf(entry.search(lowerCase)), (Object)entry)).filter((? super T pair) -> ((Float)pair.getLeft()).floatValue() > 0.7f).sorted((a, b) -> ((Float)b.getLeft()).compareTo((Float)a.getLeft())).map(Pair::getRight).toList();
            this.m_5988_(entries);
        }
        this.activeFilter = filter.trim();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BaseEntry hovered;
        this.m_93481_(mouseX, mouseY, button);
        if (this.m_5953_(mouseX, mouseY) && (hovered = this.getEntryAtPositionFixed(mouseX, mouseY)) != null && hovered.m_6375_(mouseX, mouseY, button)) {
            if (this.m_7222_() != hovered && this.m_7222_() != null) {
                ((BaseEntry)this.m_7222_()).m_7522_(null);
            }
            this.m_7522_((GuiEventListener)hovered);
            this.m_7897_(true);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private BaseEntry getEntryAtPositionFixed(double mouseX, double mouseY) {
        int listY = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int hoveredItem = listY / this.f_93387_;
        return mouseX < (double)this.m_5756_() && hoveredItem >= 0 && listY >= 0 && hoveredItem < this.m_5773_() ? (BaseEntry)((Object)this.m_6702_().get(hoveredItem)) : null;
    }

    public boolean isEntryVisible(BaseEntry entry) {
        int index = this.m_6702_().indexOf((Object)entry);
        return this.m_7610_(index) < this.f_93391_ && this.m_93485_(index) > this.f_93390_;
    }

    protected int m_5756_() {
        return this.m_93520_() + 2;
    }

    public int m_5759_() {
        return Math.min(this.parent.f_96543_ - 30, 350);
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
    }

    public int getItemHeight() {
        return this.f_93387_;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.active && super.m_5953_(mouseX, mouseY);
    }

    public int m_7610_(int index) {
        return super.m_7610_(index);
    }

    public BaseEntry getHovered() {
        return (BaseEntry)super.m_168795_();
    }

    public static BaseEntry ConfigToEntry(ConfigBuilder.ConfigValue<?> configValue) {
        ResettableEntry entry = new ResettableEntry((Component)Component.m_237115_((String)("vivecraft.serverSettings." + configValue.getPath())), configValue);
        ((BaseEntry)entry).setActive(Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().m_91090_());
        return entry;
    }

    public static BaseEntry vrOptionToEntry(VRSettings.VrOptions option) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        String optionString = "vivecraft.options." + option.name();
        WidgetEntry entry = dh.vrSettings.hasValue(option) ? new ResettableEntry((Component)Component.m_237115_((String)optionString), option) : new WidgetEntry((Component)Component.m_237115_((String)optionString), SettingsList.vrOptionToWidget(option, 145), () -> TooltipUtil.getClientConfigTooltip(option), null);
        if (dh.vrSettings.overrides.hasSetting(option) && dh.vrSettings.overrides.getSetting(option).isValueOverridden()) {
            ((BaseEntry)entry).setActive(false);
        }
        return entry;
    }

    private static AbstractWidget vrOptionToWidget(VRSettings.VrOptions option, int width) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        GuiVROptionSlider widget = option.getEnumFloat() ? new GuiVROptionSlider(option.returnEnumOrdinal(), 0, 0, width, 20, option, true) : Button.m_253074_((Component)Component.m_237113_((String)dh.vrSettings.getButtonDisplayString(option, true)), button -> {
            dh.vrSettings.setOptionValue(option);
            button.m_93666_((Component)Component.m_237113_((String)dh.vrSettings.getButtonDisplayString(option, true)));
        }).m_253046_(width, 20).m_253136_();
        return widget;
    }

    public static abstract class BaseEntry
    extends ContainerObjectSelectionList.Entry<BaseEntry> {
        protected final Component name;
        private final Supplier<String> tooltip;
        private boolean active = true;
        private boolean parentActive = true;

        public BaseEntry(Component name, Supplier<String> tooltipSupplier) {
            this.name = name;
            this.tooltip = tooltipSupplier == null ? () -> "" : tooltipSupplier;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_() || hovering && Minecraft.m_91087_().m_264529_().m_264588_()) {
                guiGraphics.m_285944_(RenderType.m_286086_(), left - 2, top, left + width, top + 20, Integer.MIN_VALUE);
            }
        }

        public ComponentPath m_264176_(FocusNavigationEvent event, int index) {
            if (!this.isActive()) {
                return ComponentPath.m_264401_((GuiEventListener)this);
            }
            ComponentPath componentPath = null;
            for (int i = Math.min(index, this.m_6702_().size() - 1); componentPath == null && i >= 0; --i) {
                componentPath = ((GuiEventListener)this.m_6702_().get(i)).m_264064_(event);
            }
            return ComponentPath.m_264334_((ContainerEventHandler)this, componentPath);
        }

        protected int textColor() {
            return this.isActive() ? -1 : -6250336;
        }

        public boolean isActive() {
            return this.active && this.parentActive;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setParentActive(boolean active) {
            this.parentActive = active;
        }

        public boolean filter(String filter) {
            boolean match = false;
            ComponentContents componentContents = this.name.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents trans = (TranslatableContents)componentContents;
                match = trans.m_237508_().toLowerCase().contains(filter);
            }
            return match || this.name.getString().toLowerCase().contains(filter);
        }

        public float search(String search) {
            float matchKey = 0.0f;
            ComponentContents componentContents = this.name.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents trans = (TranslatableContents)componentContents;
                matchKey = StringSimilarity.partial_ratio(search, trans.m_237508_().toLowerCase()) * 0.9f;
            }
            float matchString = StringSimilarity.partial_ratio(search, this.name.getString().toLowerCase());
            return Math.max(matchString, matchKey);
        }

        public List<BaseEntry> getEntries() {
            return ImmutableList.of((Object)((Object)this));
        }

        public String getTooltip() {
            return this.tooltip.get();
        }
    }

    public static class ResettableEntry
    extends WidgetEntry {
        public static final int VALUE_BUTTON_WIDTH = 125;
        private final Button resetButton;
        private final BooleanSupplier canReset;

        public ResettableEntry(Component name, ConfigBuilder.ConfigValue<?> configValue) {
            this(name, configValue.getWidget(125, 20).get(), () -> TooltipUtil.getServerConfigTooltip(configValue.getPath(), true), null, () -> !configValue.isDefault(), () -> {
                configValue.reset();
                if (Minecraft.m_91087_().m_91091_()) {
                    configValue.onUpdate((MinecraftServer)Minecraft.m_91087_().m_91092_());
                    ServerNetworking.sendUpdatePacketToAll((MinecraftServer)Minecraft.m_91087_().m_91092_(), configValue);
                }
                return configValue.getWidget(125, 20).get();
            });
        }

        public ResettableEntry(Component name, VRSettings.VrOptions option) {
            this(name, SettingsList.vrOptionToWidget(option, 125), () -> TooltipUtil.getClientConfigTooltip(option), () -> {
                VRSettings.ServerOverrides overrides = ClientDataHolderVR.getInstance().vrSettings.overrides;
                return option.isChangeable() && (!overrides.hasSetting(option) || !overrides.getSetting(option).isValueOverridden());
            }, () -> !ClientDataHolderVR.getInstance().vrSettings.isDefault(option), () -> {
                ClientDataHolderVR.getInstance().vrSettings.loadDefault(option);
                return SettingsList.vrOptionToWidget(option, 125);
            });
        }

        private ResettableEntry(Component name, AbstractWidget widget, Supplier<String> tooltipSupplier, BooleanSupplier isActive, BooleanSupplier canReset, Supplier<AbstractWidget> resetAction) {
            super(name, widget, tooltipSupplier, isActive);
            this.canReset = canReset;
            this.resetButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> {
                this.valueWidget = (AbstractWidget)resetAction.get();
            }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controls.reset"))).m_252987_(0, 0, 20, 20).m_253136_();
            this.resetButton.m_257427_(-1);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.resetButton.m_252865_(left + width - 20);
            this.resetButton.m_253211_(top);
            this.resetButton.f_93623_ = this.isActive() && this.valueWidget.f_93623_ && this.canReset.getAsBoolean();
            this.resetButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.resetButton.f_93623_ = active;
        }
    }

    public static class WidgetEntry
    extends BaseEntry {
        public static final int VALUE_BUTTON_WIDTH = 145;
        protected final BooleanSupplier widgetActive;
        protected AbstractWidget valueWidget;

        public WidgetEntry(Component name, AbstractWidget valueWidget, Supplier<String> tooltipSupplier, BooleanSupplier widgetActive) {
            super(name, tooltipSupplier);
            this.valueWidget = valueWidget;
            this.widgetActive = widgetActive == null ? () -> true : widgetActive;
        }

        public WidgetEntry(Component name, AbstractWidget valueWidget, Supplier<String> tooltipSupplier) {
            this(name, valueWidget, tooltipSupplier, null);
        }

        public WidgetEntry(Component name, AbstractWidget valueWidget) {
            this(name, valueWidget, null, null);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.name);
            int n = top + height / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int textY = n - 9 / 2 + 2;
            if (textWidth < width - 145) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.name, left, textY, this.textColor());
            } else {
                Font font = Minecraft.m_91087_().f_91062_;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                AbstractWidget.m_280138_((GuiGraphics)guiGraphics, (Font)font, (Component)this.name, (int)left, (int)textY, (int)(left + width - 145 - 5), (int)(textY + 9 - 1), (int)this.textColor());
            }
            this.valueWidget.m_252865_(left + width - 145);
            this.valueWidget.m_253211_(top);
            this.valueWidget.f_93623_ = this.widgetActive.getAsBoolean() && this.isActive();
            this.valueWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.valueWidget.f_93623_ = active;
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final int width;

        public CategoryEntry(Component name) {
            super(name, null);
            this.width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.name);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n = Minecraft.m_91087_().f_91080_.f_96543_ / 2 - this.width / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280430_(font, this.name, n, top + height - 9 - 1, this.textColor());
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return null;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.m_169146_(NarratedElementType.TITLE, name);
                }
            });
        }
    }

    public static class ScreenEntry
    extends WidgetEntry {
        public ScreenEntry(String langKey, Function<Screen, Screen> screenFunction) {
            super((Component)Component.m_237115_((String)langKey), (AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)langKey), b -> Minecraft.m_91087_().m_91152_((Screen)screenFunction.apply(Minecraft.m_91087_().f_91080_))).m_253046_(145, 20).m_253136_(), () -> I18n.m_118936_((String)(langKey + ".tooltip")) ? I18n.m_118938_((String)(langKey + ".tooltip"), (Object[])new Object[0]) : "");
        }
    }

    public static class SelectableEntry
    extends BaseEntry {
        private final AbstractWidget mainWidget;
        private final AbstractWidget optionalWidget;

        public SelectableEntry(Component name, AbstractWidget optionalWidget, Runnable callback) {
            super(name, null);
            this.mainWidget = new TextOnlyButton(name, button -> callback.run());
            this.optionalWidget = optionalWidget;
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.m_6311_(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.mainWidget.m_252865_(left);
            this.mainWidget.m_253211_(top);
            this.mainWidget.m_93674_(this.optionalWidget == null ? width : width - 10 - this.optionalWidget.m_5711_());
            this.mainWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.optionalWidget != null) {
                this.optionalWidget.m_252865_(left + width - this.optionalWidget.m_5711_());
                this.optionalWidget.m_253211_(top);
                this.optionalWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        @Override
        public void setActive(boolean active) {
            this.mainWidget.f_93623_ = active;
            if (this.optionalWidget != null) {
                this.optionalWidget.f_93623_ = active;
            }
        }
    }

    public static class GroupedEntry
    extends CategoryEntry {
        private final ArrayList<BaseEntry> allChildren = new ArrayList();
        private final ArrayList<BaseEntry> activeChildren = new ArrayList();

        public GroupedEntry(Component name) {
            super(name);
        }

        public void add(BaseEntry entry) {
            this.allChildren.add(entry);
            this.activeChildren.add(entry);
        }

        @Override
        public boolean filter(String filter) {
            this.activeChildren.clear();
            if (super.filter(filter)) {
                this.activeChildren.addAll(this.allChildren);
            } else {
                this.activeChildren.addAll(this.allChildren.stream().filter((? super T entry) -> entry.filter(filter)).toList());
            }
            return !this.activeChildren.isEmpty();
        }

        @Override
        public List<BaseEntry> getEntries() {
            return Stream.concat(Stream.of(this), this.activeChildren.stream().flatMap(child -> child.getEntries().stream())).toList();
        }

        @Override
        public void setParentActive(boolean active) {
            super.setParentActive(active);
            this.allChildren.forEach(child -> child.setParentActive(active));
        }
    }
}

