/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PropertyRead_t")
public class PropertyRead
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROP;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int UNREQUIREDBUFFERSIZE;
    public static final int EERROR;

    public PropertyRead(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), PropertyRead.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ETrackedDeviceProperty")
    public int prop() {
        return PropertyRead.nprop(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PropertyRead.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PropertyRead.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PropertyRead.nunTag(this.address());
    }

    @NativeType(value="uint32_t")
    public int unRequiredBufferSize() {
        return PropertyRead.nunRequiredBufferSize(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PropertyRead.neError(this.address());
    }

    public PropertyRead prop(@NativeType(value="ETrackedDeviceProperty") int value) {
        PropertyRead.nprop(this.address(), value);
        return this;
    }

    public PropertyRead pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PropertyRead.npvBuffer(this.address(), value);
        return this;
    }

    public PropertyRead unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PropertyRead.nunTag(this.address(), value);
        return this;
    }

    public PropertyRead unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
        PropertyRead.nunRequiredBufferSize(this.address(), value);
        return this;
    }

    public PropertyRead eError(@NativeType(value="ETrackedPropertyError") int value) {
        PropertyRead.neError(this.address(), value);
        return this;
    }

    public PropertyRead set(int prop, ByteBuffer pvBuffer, int unTag, int unRequiredBufferSize, int eError) {
        this.prop(prop);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.unRequiredBufferSize(unRequiredBufferSize);
        this.eError(eError);
        return this;
    }

    public PropertyRead set(PropertyRead src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static PropertyRead malloc() {
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static PropertyRead calloc() {
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static PropertyRead create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static PropertyRead create(long address) {
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)address);
    }

    @Nullable
    public static PropertyRead createSafe(long address) {
        return address == 0L ? null : (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)PropertyRead.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PropertyRead.__create((int)capacity, (int)SIZEOF);
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)PropertyRead.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static PropertyRead malloc(MemoryStack stack) {
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static PropertyRead calloc(MemoryStack stack) {
        return (PropertyRead)PropertyRead.wrap(PropertyRead.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)PropertyRead.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nprop(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROP);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)), (int)PropertyRead.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTAG);
    }

    public static int nunRequiredBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNREQUIREDBUFFERSIZE);
    }

    public static int neError(long struct) {
        return UNSAFE.getInt(null, struct + (long)EERROR);
    }

    public static void nprop(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROP, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVBUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        PropertyRead.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNTAG, value);
    }

    public static void nunRequiredBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNREQUIREDBUFFERSIZE, value);
    }

    public static void neError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EERROR, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)));
    }

    static {
        Struct.Layout layout = PropertyRead.__struct((Struct.Member[])new Struct.Member[]{PropertyRead.__member((int)4), PropertyRead.__member((int)POINTER_SIZE), PropertyRead.__member((int)4), PropertyRead.__member((int)4), PropertyRead.__member((int)4), PropertyRead.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROP = layout.offsetof(0);
        PVBUFFER = layout.offsetof(1);
        UNBUFFERSIZE = layout.offsetof(2);
        UNTAG = layout.offsetof(3);
        UNREQUIREDBUFFERSIZE = layout.offsetof(4);
        EERROR = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<PropertyRead, Buffer>
    implements NativeResource {
        private static final PropertyRead ELEMENT_FACTORY = PropertyRead.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected PropertyRead getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ETrackedDeviceProperty")
        public int prop() {
            return PropertyRead.nprop(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PropertyRead.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PropertyRead.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PropertyRead.nunTag(this.address());
        }

        @NativeType(value="uint32_t")
        public int unRequiredBufferSize() {
            return PropertyRead.nunRequiredBufferSize(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PropertyRead.neError(this.address());
        }

        public Buffer prop(@NativeType(value="ETrackedDeviceProperty") int value) {
            PropertyRead.nprop(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PropertyRead.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PropertyRead.nunTag(this.address(), value);
            return this;
        }

        public Buffer unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
            PropertyRead.nunRequiredBufferSize(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PropertyRead.neError(this.address(), value);
            return this;
        }
    }
}

