/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.transformer.SrgRemappingReferenceMapper;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.Transformer;

public class RefmapRemapper
implements Transformer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final String INTERMEDIARY_MAPPING_ENV = "named:intermediary";
    private static final String SRG_MAPPING_ENV = "searge";
    private final Collection<String> visibleMixinConfigs;
    private final Map<String, SrgRemappingReferenceMapper.SimpleRefmap> files;
    private boolean hasManifest;

    public static RefmapFiles processRefmaps(Path input, Collection<String> refmaps, SrgRemappingReferenceMapper remapper, List<Path> libs) throws IOException {
        SrgRemappingReferenceMapper.SimpleRefmap results = new SrgRemappingReferenceMapper.SimpleRefmap(Map.of(), Map.of());
        HashMap<String, SrgRemappingReferenceMapper.SimpleRefmap> refmapFiles = new HashMap<String, SrgRemappingReferenceMapper.SimpleRefmap>();
        try (FileSystem fs = FileSystems.newFileSystem(input);){
            for (String refmap : refmaps) {
                Path refmapPath = fs.getPath(refmap, new String[0]);
                if (Files.notExists(refmapPath, new LinkOption[0])) {
                    refmapPath = RefmapRemapper.findRefmapOnClasspath(refmap, input, libs);
                }
                if (refmapPath != null) {
                    byte[] data = Files.readAllBytes(refmapPath);
                    SrgRemappingReferenceMapper.SimpleRefmap remapped = RefmapRemapper.remapRefmapInPlace(data, remapper);
                    refmapFiles.put(refmap, remapped);
                    results = results.merge(remapped);
                    continue;
                }
                LOGGER.warn("Refmap remapper could not find refmap file {}", (Object)refmap);
            }
        }
        return new RefmapFiles(results, refmapFiles);
    }

    @Nullable
    private static Path findRefmapOnClasspath(String resource, Path exclude, List<Path> libs) {
        for (Path lib : libs) {
            Path path;
            Path basePath;
            if (lib == exclude) continue;
            if (Files.isDirectory(lib, new LinkOption[0])) {
                basePath = lib;
            } else {
                try {
                    FileSystem fs = FileSystems.newFileSystem(lib);
                    basePath = fs.getPath("", new String[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Error opening jar file", (Throwable)e);
                    return null;
                }
            }
            if (!Files.exists(path = basePath.resolve(resource), new LinkOption[0])) continue;
            return path;
        }
        return null;
    }

    public RefmapRemapper(Collection<String> visibleMixinConfigs, Map<String, SrgRemappingReferenceMapper.SimpleRefmap> files) {
        this.visibleMixinConfigs = visibleMixinConfigs;
        this.files = files;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        String name = entry.getName();
        if (this.files.containsKey(name)) {
            Transformer.ResourceEntry resourceEntry;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                try (OutputStreamWriter writer = new OutputStreamWriter(byteStream);){
                    this.files.get(name).write(writer);
                    ((Writer)writer).flush();
                }
                byte[] data = byteStream.toByteArray();
                resourceEntry = Transformer.ResourceEntry.create(name, entry.getTime(), data);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        byteStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            byteStream.close();
            return resourceEntry;
        }
        return entry;
    }

    @Override
    public Transformer.ManifestEntry process(Transformer.ManifestEntry entry) {
        this.hasManifest = true;
        if (!this.visibleMixinConfigs.isEmpty()) {
            Transformer.ManifestEntry manifestEntry;
            Manifest manifest = new Manifest();
            ByteArrayInputStream is = new ByteArrayInputStream(entry.getData());
            try {
                manifest.read(is);
                manifestEntry = this.modifyManifest(manifest, entry.getTime());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error writing manifest", e);
                }
            }
            ((InputStream)is).close();
            return manifestEntry;
        }
        return entry;
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        if (!this.visibleMixinConfigs.isEmpty() && !this.hasManifest) {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            return List.of(this.modifyManifest(manifest, 318211200000L));
        }
        return List.of();
    }

    private Transformer.ManifestEntry modifyManifest(Manifest manifest, long time) {
        Transformer.ManifestEntry manifestEntry;
        manifest.getMainAttributes().putValue("MixinConfigs", String.join((CharSequence)",", this.visibleMixinConfigs));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            manifest.write(byteStream);
            manifestEntry = Transformer.ManifestEntry.create(time, byteStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error writing generated manifest", e);
            }
        }
        byteStream.close();
        return manifestEntry;
    }

    private static SrgRemappingReferenceMapper.SimpleRefmap remapRefmapInPlace(byte[] data, SrgRemappingReferenceMapper remapper) {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));
        SrgRemappingReferenceMapper.SimpleRefmap simpleRefmap = (SrgRemappingReferenceMapper.SimpleRefmap)GSON.fromJson((Reader)reader, SrgRemappingReferenceMapper.SimpleRefmap.class);
        Map<String, String> replacements = Map.of(INTERMEDIARY_MAPPING_ENV, SRG_MAPPING_ENV);
        return remapper.remap(simpleRefmap, replacements);
    }

    public record RefmapFiles(SrgRemappingReferenceMapper.SimpleRefmap merged, Map<String, SrgRemappingReferenceMapper.SimpleRefmap> files) {
    }
}

