/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class SaturationTracker {
    private static final int[] FEEDING_THRESHOLDS = new int[]{5, 10, 15, 20};
    private static final Map<ResourceLocation, LootTable> LOOT_CACHE = new ConcurrentHashMap<ResourceLocation, LootTable>();
    private int level = 0;
    private int foodCounter = 0;
    private long lastFedTick = -1L;
    private int decayDelay = -1;
    private int nextDecayTick = -1;
    private int nextTickCheck = 0;

    public void tryFeed(Animal animal, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!animal.m_6898_(stack) || animal.m_6162_()) {
            return;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        ++this.foodCounter;
        this.lastFedTick = animal.f_19797_;
        this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
        this.nextDecayTick = animal.f_19797_ + this.decayDelay;
        if (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            ++this.level;
            this.foodCounter = 0;
        }
    }

    public void tick(Animal animal) {
        int now = animal.f_19797_;
        if (now < this.nextTickCheck) {
            return;
        }
        this.nextTickCheck = now + 20;
        if (this.nextDecayTick == -1) {
            return;
        }
        if (now >= this.nextDecayTick) {
            if (this.foodCounter > 0) {
                --this.foodCounter;
            } else if (this.level > 0) {
                --this.level;
                this.foodCounter = FEEDING_THRESHOLDS[Math.max(0, this.level - 1)] - 1;
            }
            this.lastFedTick = now;
            this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
            this.nextDecayTick = now + this.decayDelay;
        }
    }

    public void dropExtraLoot(Animal animal, DamageSource source) {
        int bonusRolls;
        Level level = animal.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int n = this.level == 1 ? 1 : (this.level == 2 ? 1 + animal.m_217043_().m_188503_(2) : (this.level == 3 ? 2 + animal.m_217043_().m_188503_(2) : (bonusRolls = this.level == 4 ? 3 : 0)));
        if (bonusRolls == 0) {
            return;
        }
        LootParams params = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)animal).m_287286_(LootContextParams.f_81460_, (Object)animal.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287235_(LootContextParamSets.f_81415_);
        LootTable table = LOOT_CACHE.computeIfAbsent(animal.m_5743_(), id -> serverLevel.m_7654_().m_278653_().m_278676_(id));
        Consumer<ItemStack> spawn = stack -> serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, animal.m_20185_(), animal.m_20186_(), animal.m_20189_(), stack));
        for (int i = 0; i < bonusRolls; ++i) {
            table.m_287228_(params, spawn);
        }
    }

    public int level() {
        return this.level;
    }

    public int foodCounter() {
        return this.foodCounter;
    }

    public void feedDirectly(Animal animal, int currentTick, int amount) {
        this.foodCounter += amount;
        this.lastFedTick = currentTick;
        this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
        this.nextDecayTick = currentTick + this.decayDelay;
        while (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            this.foodCounter -= FEEDING_THRESHOLDS[this.level];
            ++this.level;
        }
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    public void setDecayDelay(int delay) {
        this.decayDelay = delay;
        this.nextDecayTick = (int)this.lastFedTick + delay;
    }

    public long getLastFedTick() {
        return this.lastFedTick;
    }

    public void setLastFedTick(long tick) {
        this.lastFedTick = tick;
        if (this.decayDelay > 0) {
            this.nextDecayTick = (int)tick + this.decayDelay;
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setFoodCounter(int count) {
        this.foodCounter = count;
    }

    public void clientSync(int syncedLevel, int syncedFoodCounter) {
        this.level = syncedLevel;
        this.foodCounter = syncedFoodCounter;
    }

    public static interface SaturatedAnimal {
        public SaturationTracker farm_and_charm$getSaturationTracker();

        public void farm_and_charm$setSaturationTracker(SaturationTracker var1);
    }
}

