/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class StoveRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final float experience;
    private final boolean requiresLearning;

    public StoveRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, float experience, boolean requiresLearning) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.experience = experience;
        this.requiresLearning = requiresLearning;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 1, 3);
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.STOVE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean requiresLearning() {
        return this.requiresLearning;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StoveRecipe> {
        @NotNull
        public StoveRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Stove Recipe");
            }
            if (ingredients.size() > 3) {
                throw new JsonParseException("Too many ingredients for Stove Recipe");
            }
            boolean requiresLearning = GsonHelper.m_13855_((JsonObject)json, (String)"requiresLearning", (boolean)false);
            return new StoveRecipe(id, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")), GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f), requiresLearning);
        }

        @NotNull
        public StoveRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            float xp = buf.readFloat();
            boolean requiresLearning = buf.readBoolean();
            return new StoveRecipe(id, (NonNullList<Ingredient>)ingredients, output, xp, requiresLearning);
        }

        public void toNetwork(FriendlyByteBuf buf, StoveRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.output);
            buf.writeFloat(recipe.experience);
            buf.writeBoolean(recipe.requiresLearning);
        }
    }
}

