/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.network.handler.SyncSaturationPacketClientHandler;
import net.satisfy.farm_and_charm.core.network.packet.SetTextPacket;
import net.satisfy.farm_and_charm.core.network.packet.SyncSaturationPacket;
import net.satisfy.farm_and_charm.core.util.FarmAndCharmIdentifier;

public class PacketHandler {
    public static final ResourceLocation SET_SIGN_TEXT = new FarmAndCharmIdentifier("set_text");
    public static final ResourceLocation SYNC_SATURATION = new FarmAndCharmIdentifier("sync_saturation");

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)SET_SIGN_TEXT, (buf, context) -> {
            SetTextPacket packet = SetTextPacket.decode(buf);
            context.queue(() -> SetTextPacket.handle(packet, (ServerPlayer)context.getPlayer()));
        });
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)SYNC_SATURATION, (buf, context) -> {
                SyncSaturationPacket packet = SyncSaturationPacket.decode(buf);
                context.queue(() -> SyncSaturationPacketClientHandler.handle(packet));
            });
        }
    }

    public static void sendToClient(ServerPlayer player, SyncSaturationPacket packet) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        SyncSaturationPacket.encode(packet, buf);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)SYNC_SATURATION, (FriendlyByteBuf)buf);
    }

    public static void sendToServer(SetTextPacket packet) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        SetTextPacket.encode(packet, buf);
        NetworkManager.sendToServer((ResourceLocation)SET_SIGN_TEXT, (FriendlyByteBuf)buf);
    }

    public static void sendSaturationSync(SyncSaturationPacket packet, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                SyncSaturationPacket.encode(packet, buf);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)SYNC_SATURATION, (FriendlyByteBuf)buf);
            }
        }
    }
}

