/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class FertilizedSoilBlock
extends Block {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)3);

    public FertilizedSoilBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(3)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)SIZE)) {
            case 0 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
            case 1 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
            case 2 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean hasSugarCaneAbove = level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50130_);
        if (itemStack.m_41720_() == ObjectRegistry.PITCHFORK.get()) {
            if (hasSugarCaneAbove) {
                return InteractionResult.PASS;
            }
            int newSize = (Integer)state.m_61143_((Property)SIZE) - 1;
            if (newSize < 0) {
                level.m_7471_(pos, false);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(newSize)), 3);
                this.applyBoneMealEffect(level, pos);
            }
            this.spawnParticles(level, pos, state, false);
            level.m_5594_(null, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_41720_() instanceof HoeItem) {
            if (hasSugarCaneAbove) {
                return InteractionResult.PASS;
            }
            int currentSize = (Integer)state.m_61143_((Property)SIZE);
            if (currentSize == 3) {
                level.m_7731_(pos, ((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get()).m_49966_(), 3);
                if (!player.m_7500_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                level.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private void spawnParticles(Level level, BlockPos pos, BlockState state, boolean happy) {
        if (!level.f_46443_) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.2);
            if (happy) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 4, 0.25, 0.1, 0.25, 0.01);
            }
        }
    }

    private void applyBoneMealEffect(Level level, BlockPos centerPos) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            int range = PlatformHelper.getFertilizedSoilRange();
            BlockPos.m_121990_((BlockPos)centerPos.m_7918_(-range, -1, -range), (BlockPos)centerPos.m_7918_(range, 1, range)).forEach(pos -> {
                BonemealableBlock bonemealableBlock;
                BlockState blockState;
                Block block;
                if (serverLevel.f_46441_.m_188503_(100) < 20 && (block = (blockState = serverLevel.m_8055_(pos)).m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, pos, blockState, false)) {
                    bonemealableBlock.m_214148_(serverLevel, serverLevel.f_46441_, pos, blockState);
                }
            });
        }
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.m_61143_((Property)SIZE) != 3) {
            return;
        }
        if (random.m_188503_(4) != 0) {
            return;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = 0; dy <= 1; ++dy) {
                    BlockPos above;
                    if (dx == 0 && dz == 0 && dy == 0) continue;
                    checkPos.m_122178_(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz);
                    BlockState targetState = level.m_8055_((BlockPos)checkPos);
                    if (!targetState.m_60713_(Blocks.f_50130_) || !level.m_46859_(above = checkPos.m_7494_())) continue;
                    int height = 1;
                    while (level.m_8055_(checkPos.m_6625_(height)).m_60713_(Blocks.f_50130_)) {
                        ++height;
                    }
                    if (height >= 3) continue;
                    level.m_7731_(above, Blocks.f_50130_.m_49966_(), 2);
                    this.spawnParticles((Level)level, above, Blocks.f_50130_.m_49966_(), true);
                }
            }
        }
    }
}

