/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.client.model.MincerModel;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.block.entity.MincerBlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MincerRenderer
implements BlockEntityRenderer<MincerBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("farm_and_charm", "textures/entity/mincer.png");
    private final ModelPart mincer;
    private final ModelPart crank;

    public MincerRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(MincerModel.LAYER_LOCATION);
        this.mincer = root.m_171324_("mincer");
        this.crank = root.m_171324_("crank");
    }

    public void render(MincerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        Level level = blockEntity.m_58904_();
        assert (level != null);
        BlockState blockState = level.m_8055_(blockEntity.m_58899_());
        if (!(blockState.m_60734_() instanceof MincerBlock)) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)blockState.m_61143_((Property)MincerBlock.FACING);
        Vector3f offset = new Vector3f();
        float rotationDegrees = 0.0f;
        switch (facing) {
            case NORTH: {
                offset.set(1.0f, 0.0f, 1.0f);
                rotationDegrees = 180.0f;
                break;
            }
            case EAST: {
                offset.set(0.0f, 0.0f, 1.0f);
                rotationDegrees = 90.0f;
                break;
            }
            case SOUTH: {
                offset.set(0.0f, 0.0f, 0.0f);
                break;
            }
            case WEST: {
                offset.set(1.0f, 0.0f, 0.0f);
                rotationDegrees = 270.0f;
            }
        }
        poseStack.m_252880_(offset.x, offset.y, offset.z);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationDegrees));
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.mincer.m_104301_(poseStack, vertexConsumer, light, overlay);
        if ((Integer)blockState.m_61143_((Property)MincerBlock.CRANK) > 0) {
            long time = System.currentTimeMillis();
            float angle = (float)(time % 3600L) / 5.0f;
            Quaternionf rotation = new Quaternionf().rotateX((float)Math.toRadians(-angle));
            Matrix4f matrix = new Matrix4f().translate(0.5f, 0.625f, 0.5f).mul((Matrix4fc)rotation.get(new Matrix4f())).translate(-0.5f, -0.625f, -0.5f);
            poseStack.m_85850_().m_252922_().mul((Matrix4fc)matrix);
        }
        this.crank.m_104301_(poseStack, vertexConsumer, light, overlay);
        poseStack.m_85849_();
    }
}

