/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.base.item.DyedItemList;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankingGuideItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.EnumMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class NumismaticsItems {
    private static final CreateRegistrate REGISTRATE = Numismatics.registrate();
    public static final EnumMap<Coin, ItemEntry<CoinItem>> COINS = new EnumMap(Coin.class);
    public static final DyedItemList<CardItem> CARDS;
    public static final DyedItemList<IDCardItem> ID_CARDS;
    public static final ItemEntry<BankingGuideItem> BANKING_GUIDE;

    private static ItemEntry<CoinItem> makeCoin(Coin coin) {
        return REGISTRATE.item(coin.getName(), CoinItem.create(coin)).tag(new TagKey[]{NumismaticsTags.AllItemTags.COINS.tag}).lang(coin.getDisplayName()).properties(p -> p.m_41497_(coin.rarity)).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{p.modLoc("item/coin/" + coin.getName())})).register();
    }

    public static ItemEntry<CoinItem> getCoin(Coin coin) {
        return COINS.get((Object)coin);
    }

    public static void register() {
        Numismatics.LOGGER.info("Registering items for Create: Numismatics");
    }

    static {
        for (Coin coin : Coin.values()) {
            COINS.put(coin, NumismaticsItems.makeCoin(coin));
        }
        CARDS = new DyedItemList<CardItem>(color -> {
            String colorName = color.m_7912_();
            return ((ItemBuilder)REGISTRATE.item(colorName + "_card", p -> new CardItem((Item.Properties)p, (DyeColor)color)).properties(p -> p.m_41487_(1)).tag(new TagKey[]{NumismaticsTags.AllItemTags.CARDS.tag}).lang(TextUtils.titleCaseConversion(color.m_41065_()) + " Card").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Numismatics.asResource("item/card/" + colorName + "_card")})).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)"item.numismatics.bank_card"))).register();
        });
        ID_CARDS = new DyedItemList<IDCardItem>(color -> {
            String colorName = color.m_7912_();
            return ((ItemBuilder)REGISTRATE.item(colorName + "_id_card", p -> new IDCardItem((Item.Properties)p, (DyeColor)color)).properties(p -> p.m_41487_(16)).tag(new TagKey[]{NumismaticsTags.AllItemTags.ID_CARDS.tag}).lang(TextUtils.titleCaseConversion(color.m_41065_()) + " ID Card").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Numismatics.asResource("item/id_card/" + colorName + "_id_card")})).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)"item.numismatics.id_card"))).register();
        });
        BANKING_GUIDE = REGISTRATE.item("banking_guide", BankingGuideItem::new).lang("Banking Guide").register();
    }
}

