/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinDisplaySlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotDiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BrassDepositorMenu
extends MenuBase<BrassDepositorBlockEntity> {
    public static final int COIN_SLOTS;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;

    public BrassDepositorMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public BrassDepositorMenu(MenuType<?> type, int id, Inventory inv, BrassDepositorBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected BrassDepositorBlockEntity createOnClient(FriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity blockEntity = world.m_7702_(extraData.m_130135_());
        if (blockEntity instanceof BrassDepositorBlockEntity) {
            BrassDepositorBlockEntity brassDepositorBE = (BrassDepositorBlockEntity)blockEntity;
            brassDepositorBE.readClient(extraData.m_130260_());
            return brassDepositorBE;
        }
        return null;
    }

    protected void initAndReadInventory(BrassDepositorBlockEntity contentHolder) {
    }

    protected void addSlots() {
        int x = 37;
        int y = 122;
        for (Coin coin : Coin.values()) {
            this.m_38897_(new SlotDiscreteCoinBag(((BrassDepositorBlockEntity)this.contentHolder).inventory, coin, x += 18, y, true, true));
        }
        this.m_38897_(new CardSlot.BoundCardSlot(((BrassDepositorBlockEntity)this.contentHolder).cardContainer, 0, 37, y));
        this.addPlayerSlots(44, 165);
        int labelX1 = 25;
        int labelX2 = labelX1 + 86;
        int labelY = 46;
        int labelYIncrement = 22;
        for (int i = 0; i < 6; ++i) {
            Coin coin = Coin.values()[i];
            int slotX = i < 3 ? labelX1 : labelX2;
            int slotY = labelY + i % 3 * labelYIncrement;
            this.m_38897_(new CoinDisplaySlot(coin, slotX, slotY));
        }
    }

    protected void saveData(BrassDepositorBlockEntity contentHolder) {
    }

    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        super.m_150399_(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = this.m_38853_(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = clickedSlot.m_7993_();
        if (index < COIN_SLOTS) {
            Item item = stack.m_41720_();
            if (!(item instanceof CoinItem)) {
                return ItemStack.f_41583_;
            }
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int startCount = stack.m_41613_();
            this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false);
            int diff = startCount - stack.m_41613_();
            if (diff > 0) {
                ((BrassDepositorBlockEntity)this.contentHolder).inventory.subtract(coin, diff);
                clickedSlot.m_6654_();
            } else if (diff < 0) {
                ((BrassDepositorBlockEntity)this.contentHolder).inventory.add(coin, -diff);
                clickedSlot.m_6654_();
            }
            return ItemStack.f_41583_;
        }
        if (index == CARD_SLOT_INDEX) {
            if (!this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (stack.m_41720_() instanceof CoinItem && !this.m_38903_(stack, 0, COIN_SLOTS, false)) {
                return ItemStack.f_41583_;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.m_38903_(stack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.m_38903_(stack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    static {
        CARD_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }
}

