/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardSlot;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BlazeBankerMenu
extends MenuBase<BlazeBankerBlockEntity> {
    public static final int ID_CARD_SLOTS = 27;
    public static final int CARD_SLOT_INDEX = 27;
    public static final int PLAYER_INV_START_INDEX = 28;
    public static final int PLAYER_HOTBAR_END_INDEX = 37;
    public static final int PLAYER_INV_END_INDEX = 64;
    private CardWritingContainer cardWritingContainer;

    public BlazeBankerMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected BlazeBankerMenu(MenuType<?> type, int id, Inventory inv, BlazeBankerBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected BlazeBankerBlockEntity createOnClient(FriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity blockEntity = world.m_7702_(extraData.m_130135_());
        if (blockEntity instanceof BlazeBankerBlockEntity) {
            BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
            blazeBankerBE.readClient(extraData.m_130260_());
            return blazeBankerBE;
        }
        return null;
    }

    protected void initAndReadInventory(BlazeBankerBlockEntity contentHolder) {
    }

    protected void addSlots() {
        if (this.cardWritingContainer == null) {
            this.cardWritingContainer = new CardWritingContainer(arg_0 -> ((BlazeBankerMenu)this).m_6199_(arg_0), ((BlazeBankerBlockEntity)this.contentHolder).getAccountId());
        }
        int x = 16;
        int y = 21;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0 && i > 0) {
                x = 16;
                y += 18;
            }
            this.m_38897_(new IDCardSlot.BoundIDCardSlot(((BlazeBankerBlockEntity)this.contentHolder).getTrustListBackingContainer(), i, x, y));
            x += 18;
        }
        this.m_38897_(new CardSlot.UnboundCardSlot(this.cardWritingContainer, 0, 7, 87));
        this.addPlayerSlots(40, 130);
    }

    protected void saveData(BlazeBankerBlockEntity contentHolder) {
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (playerIn instanceof ServerPlayer) {
            this.m_150411_(this.player, this.cardWritingContainer);
        }
    }

    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.f_38839_.get(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.m_7993_());
        ItemStack returnStack = slotStack.m_41777_();
        if (index <= 27) {
            int count = slotStack.m_41613_();
            if (!this.m_38903_(slotStack, 28, 64, false)) {
                return ItemStack.f_41583_;
            }
            returnStack = ItemStack.f_41583_;
            clickedSlot.m_6201_(count);
        } else {
            if (slotStack.m_41720_() instanceof IDCardItem && IDCardItem.isBound(slotStack) && !this.m_38903_(slotStack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(slotStack) && !this.m_38903_(slotStack, 27, 28, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 28 && index < 37 && !this.m_38903_(slotStack, 37, 64, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 37 && index < 64 && !this.m_38903_(slotStack, 28, 37, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (slotStack.m_41619_()) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        return returnStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_() && startIndex >= 27) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (!itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.m_41613_() + stack.m_41613_();
                    if (j <= stack.m_41741_()) {
                        stack.m_41764_(0);
                        itemStack.m_41764_(j);
                        slot.m_6654_();
                        bl = true;
                    } else if (itemStack.m_41613_() < stack.m_41741_()) {
                        stack.m_41774_(stack.m_41741_() - itemStack.m_41613_());
                        itemStack.m_41764_(stack.m_41741_());
                        slot.m_6654_();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (itemStack.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_269060_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_269060_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    private static class CardWritingContainer
    implements Container {
        private final Consumer<CardWritingContainer> slotsChangedCallback;
        private final UUID uuid;
        @NotNull
        protected final List<ItemStack> stacks = new ArrayList<ItemStack>();

        public CardWritingContainer(Consumer<CardWritingContainer> slotsChangedCallback, UUID uuid) {
            this.slotsChangedCallback = slotsChangedCallback;
            this.uuid = uuid;
            this.stacks.add(ItemStack.f_41583_);
        }

        public int m_6643_() {
            return 1;
        }

        protected ItemStack getStack() {
            return this.stacks.get(0);
        }

        public boolean m_7983_() {
            return this.getStack().m_41619_();
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            return this.getStack();
        }

        @NotNull
        public ItemStack m_7407_(int slot, int amount) {
            ItemStack stack = ContainerHelper.m_18969_(this.stacks, (int)0, (int)amount);
            if (!stack.m_41619_()) {
                this.slotsChangedCallback.accept(this);
            }
            return stack;
        }

        @NotNull
        public ItemStack m_8016_(int slot) {
            return ContainerHelper.m_18966_(this.stacks, (int)0);
        }

        public void m_6836_(int slot, @NotNull ItemStack stack) {
            this.stacks.set(0, stack);
            if (!CardItem.isBound(stack) && NumismaticsTags.AllItemTags.CARDS.matches(stack)) {
                CardItem.set(stack, this.uuid);
            }
            this.slotsChangedCallback.accept(this);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@NotNull Player player) {
            return true;
        }

        public void m_6211_() {
            this.stacks.set(0, ItemStack.f_41583_);
        }
    }
}

