/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend;

import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.BankMenu;
import dev.ithundxr.createnumismatics.content.coins.LinkedMergingCoinBag;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import dev.ithundxr.createnumismatics.multiloader.PlayerSelection;
import dev.ithundxr.createnumismatics.multiloader.S2CPacket;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.packets.BankAccountLabelPacket;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BankAccount
implements MenuProvider {
    public final UUID id;
    public final Type type;
    private int balance;
    @Nullable
    private List<UUID> trustList;
    @Nullable
    private String label;
    public final MergingCoinBag linkedCoinBag = new BankAccountCoinBag();
    private final boolean clientSide;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return BankAccount.this.balance;
        }

        public void m_8050_(int index, int value) {
            if (BankAccount.this.clientSide) {
                BankAccount.this.setBalance(value);
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public BankAccount(UUID id, Type type) {
        this(id, 0, type);
    }

    public BankAccount(UUID id, int balance, Type type) {
        this(id, type, balance, false);
    }

    protected BankAccount(UUID id, Type type, int balance, boolean clientSide) {
        this.id = id;
        this.type = type;
        this.balance = balance;
        this.clientSide = clientSide;
        if (type.useTrustList && !clientSide) {
            this.trustList = new ArrayList<UUID>();
        }
    }

    public static BankAccount clientSide(FriendlyByteBuf buf) {
        return new BankAccount(buf.m_130259_(), Type.read(buf), buf.m_130242_(), true);
    }

    public int getBalance() {
        return this.balance;
    }

    public void setBalance(int balance) {
        if (balance == this.balance) {
            return;
        }
        if (balance < 0) {
            Numismatics.crashDev("Balance cannot be negative! (Account: " + String.valueOf(this) + ")");
        }
        this.balance = balance;
        this.markDirty();
    }

    public void deposit(Coin coin, int count) {
        this.deposit(coin.toSpurs(count));
    }

    public void deposit(int amount) {
        if (amount < 0) {
            Numismatics.crashDev("Cannot add negative amount to balance! (Account: " + String.valueOf(this) + ")");
            return;
        }
        this.setBalance(this.getBalance() + amount);
    }

    public boolean deduct(Coin coin, int amount) {
        return this.deduct(coin, amount, false);
    }

    public boolean deduct(int amount) {
        return this.deduct(amount, false);
    }

    public boolean deduct(Coin coin, int amount, boolean force) {
        return this.deduct(coin.toSpurs(amount), force);
    }

    public boolean deduct(int amount, boolean force) {
        if (amount < 0) {
            Numismatics.crashDev("Cannot remove negative amount from balance! (Account: " + String.valueOf(this) + ")");
            return false;
        }
        if (this.getBalance() < amount) {
            if (force) {
                this.setBalance(0);
            }
            return false;
        }
        this.setBalance(this.getBalance() - amount);
        return true;
    }

    public String toString() {
        return super.toString() + " {id=" + String.valueOf(this.id) + ", balance=" + this.balance + ", clientside=" + this.clientSide + "}";
    }

    public static BankAccount create(Type type) {
        return new BankAccount(UUID.randomUUID(), type);
    }

    public static BankAccount load(CompoundTag nbt) {
        if (!nbt.m_128403_("id")) {
            Numismatics.LOGGER.error("Account found without ID, deleting");
            return null;
        }
        BankAccount account = new BankAccount(nbt.m_128342_("id"), Type.read(nbt));
        account.balance = nbt.m_128451_("balance");
        if (account.trustList != null && nbt.m_128441_("TrustList")) {
            account.trustList.clear();
            account.trustList.addAll(NBTHelper.readCompoundList((ListTag)nbt.m_128437_("TrustList", 10), tag -> tag.m_128342_("UUID")));
        }
        if (account.type.hasLabel && nbt.m_128425_("Label", 8)) {
            account.label = nbt.m_128461_("Label");
        }
        return account;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128362_("id", this.id);
        this.type.write(nbt);
        nbt.m_128405_("balance", this.balance);
        if (this.type.useTrustList && this.trustList != null) {
            this.trustList = this.trustList.stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            nbt.m_128365_("TrustList", (Tag)NBTHelper.writeCompoundList(this.trustList, uuid -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("UUID", uuid);
                return tag;
            }));
        }
        if (this.type.hasLabel && this.label != null) {
            nbt.m_128359_("Label", this.label);
        }
        return nbt;
    }

    public void markDirty() {
        if (!this.clientSide) {
            Numismatics.BANK.markBankDirty();
        }
    }

    @Nullable
    public String getLabel() {
        return this.type.hasLabel ? this.label : null;
    }

    public void setLabel(@Nullable String label) {
        if (this.type.hasLabel) {
            if (this.label != null && this.label.equals(label)) {
                return;
            }
            this.label = label;
            this.markDirty();
            NumismaticsPackets.PACKETS.sendTo(PlayerSelection.all(), (S2CPacket)new BankAccountLabelPacket(this));
        }
    }

    @NotNull
    public Component m_5446_() {
        if (this.getLabel() != null) {
            return Component.m_237113_((String)this.getLabel());
        }
        String name = UsernameUtils.INSTANCE.getName(this.id, null);
        if (name != null) {
            return Component.m_237113_((String)name);
        }
        return Component.m_237115_((String)"block.numismatics.bank_terminal");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new BankMenu((MenuType)NumismaticsMenuTypes.BANK.get(), i, inventory, this, this.dataAccess);
    }

    public void sendToMenu(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        this.type.write(buf);
        buf.m_130130_(this.balance);
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isAuthorized(Player player) {
        return this.isAuthorized(player.m_20148_());
    }

    public boolean isAuthorized(@Nullable UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return uuid.equals(this.id) || this.type.useTrustList && this.trustList != null && this.trustList.contains(uuid);
    }

    public void updateTrustList(Consumer<List<UUID>> updater) {
        if (this.trustList != null) {
            updater.accept(this.trustList);
            this.markDirty();
        }
    }

    public static enum Type {
        PLAYER(false, false),
        BLAZE_BANKER(true, true);

        public final boolean useTrustList;
        public final boolean hasLabel;

        private Type(boolean useTrustList, boolean hasLabel) {
            this.useTrustList = useTrustList;
            this.hasLabel = hasLabel;
        }

        public static Type read(FriendlyByteBuf buf) {
            return Type.values()[buf.readInt()];
        }

        public static Type read(CompoundTag nbt) {
            String name = nbt.m_128461_("AccountType");
            try {
                return Type.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return PLAYER;
            }
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeInt(this.ordinal());
        }

        public void write(CompoundTag nbt) {
            nbt.m_128359_("AccountType", this.name());
        }
    }

    private class BankAccountCoinBag
    extends LinkedMergingCoinBag {
        private BankAccountCoinBag() {
        }

        @Override
        protected int getDelegate() {
            return BankAccount.this.getBalance();
        }

        @Override
        protected void setDelegate(int value) {
            BankAccount.this.setBalance(value);
        }
    }
}

