/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.steamEngine;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PoweredShaftBlock
extends AbstractShaftBlock {
    public PoweredShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.EIGHT_VOXEL_POLE.get((Direction.Axis)pState.m_61143_((Property)AXIS));
    }

    @Override
    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.POWERED_SHAFT.get();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_() || !pPlayer.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        IPlacementHelper helper = PlacementHelpers.get((int)ShaftBlock.placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)heldItem.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!PoweredShaftBlock.stillValid(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)((Direction.Axis)pState.m_61143_((Property)AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)pState.m_61143_((Property)WATERLOGGED))), 3);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return AllBlocks.SHAFT.asStack();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PoweredShaftBlock.stillValid(pState, pLevel, pPos);
    }

    public static boolean stillValid(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        for (Direction d : Iterate.directions) {
            BlockPos enginePos;
            BlockState engineState;
            Block block;
            if (d.m_122434_() == pState.m_61143_((Property)AXIS) || !((block = (engineState = pLevel.m_8055_(enginePos = pPos.m_5484_(d, 2))).m_60734_()) instanceof SteamEngineBlock)) continue;
            SteamEngineBlock engine = (SteamEngineBlock)block;
            if (!SteamEngineBlock.getShaftPos(engineState, enginePos).equals((Object)pPos) || !SteamEngineBlock.isShaftValid(engineState, pState)) continue;
            return true;
        }
        return false;
    }

    public static BlockState getEquivalent(BlockState stateForPlacement) {
        return (BlockState)((BlockState)AllBlocks.POWERED_SHAFT.getDefaultState().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)stateForPlacement.m_61143_((Property)ShaftBlock.AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)stateForPlacement.m_61143_((Property)WATERLOGGED)));
    }
}

