/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.source.AccumulatedItemCountDisplaySource;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltTunnelInteractionHandler {
    public static boolean flapTunnelsAndCheckIfStuck(BeltInventory beltInventory, TransportedItemStack current, float nextOffset) {
        int currentSegment = (int)current.beltPosition;
        int upcomingSegment = (int)nextOffset;
        Direction movementFacing = beltInventory.belt.getMovementFacing();
        if (!beltInventory.beltMovementPositive && nextOffset == 0.0f) {
            upcomingSegment = -1;
        }
        if (currentSegment == upcomingSegment) {
            return false;
        }
        if (BeltTunnelInteractionHandler.stuckAtTunnel(beltInventory, upcomingSegment, current.stack, movementFacing)) {
            current.beltPosition = (float)currentSegment + (beltInventory.beltMovementPositive ? 0.99f : 0.01f);
            return true;
        }
        Level world = beltInventory.belt.m_58904_();
        boolean onServer = !world.f_46443_ || beltInventory.belt.isVirtual();
        boolean removed = false;
        BeltTunnelBlockEntity nextTunnel = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, upcomingSegment);
        int transferred = current.stack.m_41613_();
        if (nextTunnel instanceof BrassTunnelBlockEntity) {
            BrassTunnelBlockEntity brassTunnel = (BrassTunnelBlockEntity)nextTunnel;
            if (brassTunnel.hasDistributionBehaviour()) {
                if (!brassTunnel.canTakeItems()) {
                    return true;
                }
                if (onServer) {
                    brassTunnel.setStackToDistribute(current.stack, movementFacing.m_122424_());
                    current.stack = ItemStack.f_41583_;
                    beltInventory.belt.notifyUpdate();
                }
                removed = true;
            }
        } else if (nextTunnel != null) {
            BlockState blockState = nextTunnel.m_58900_();
            if (current.stack.m_41613_() > 1 && AllBlocks.ANDESITE_TUNNEL.has(blockState) && BeltTunnelBlock.isJunction(blockState) && movementFacing.m_122434_() == blockState.m_61143_(BeltTunnelBlock.HORIZONTAL_AXIS)) {
                for (Direction d : Iterate.horizontalDirections) {
                    if (d.m_122434_() == blockState.m_61143_(BeltTunnelBlock.HORIZONTAL_AXIS) || !nextTunnel.flaps.containsKey(d)) continue;
                    BlockPos outpos = nextTunnel.m_58899_().m_7495_().m_121945_(d);
                    if (!world.m_46749_(outpos)) {
                        return true;
                    }
                    DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, outpos, DirectBeltInputBehaviour.TYPE);
                    if (behaviour == null || !behaviour.canInsertFromSide(d)) continue;
                    ItemStack toinsert = ItemHandlerHelper.copyStackWithSize((ItemStack)current.stack, (int)1);
                    if (!behaviour.handleInsertion(toinsert, d, false).m_41619_()) {
                        return true;
                    }
                    if (onServer) {
                        BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, d, false);
                    }
                    current.stack.m_41774_(1);
                    beltInventory.belt.notifyUpdate();
                    if (current.stack.m_41613_() <= 1) break;
                }
            }
        }
        if (onServer) {
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, currentSegment, movementFacing, false);
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, movementFacing.m_122424_(), true);
            if (nextTunnel != null) {
                DisplayLinkBlock.sendToGatherers((LevelAccessor)world, nextTunnel.m_58899_(), (dgte, b) -> b.itemReceived((DisplayLinkBlockEntity)dgte, transferred), AccumulatedItemCountDisplaySource.class);
            }
        }
        return removed;
    }

    public static boolean stuckAtTunnel(BeltInventory beltInventory, int offset, ItemStack stack, Direction movementDirection) {
        BeltBlockEntity belt = beltInventory.belt;
        BlockPos pos = BeltHelper.getPositionForOffset(belt, offset).m_7494_();
        if (!(belt.m_58904_().m_8055_(pos).m_60734_() instanceof BrassTunnelBlock)) {
            return false;
        }
        BlockEntity be = belt.m_58904_().m_7702_(pos);
        if (be == null || !(be instanceof BrassTunnelBlockEntity)) {
            return false;
        }
        BrassTunnelBlockEntity tunnel = (BrassTunnelBlockEntity)be;
        return !tunnel.canInsert(movementDirection.m_122424_(), stack);
    }

    public static void flapTunnel(BeltInventory beltInventory, int offset, Direction side, boolean inward) {
        BeltTunnelBlockEntity be = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, offset);
        if (be == null) {
            return;
        }
        be.flap(side, inward);
    }

    protected static BeltTunnelBlockEntity getTunnelOnSegment(BeltInventory beltInventory, int offset) {
        BeltBlockEntity belt = beltInventory.belt;
        if (belt.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL) {
            return null;
        }
        return BeltTunnelInteractionHandler.getTunnelOnPosition(belt.m_58904_(), BeltHelper.getPositionForOffset(belt, offset));
    }

    public static BeltTunnelBlockEntity getTunnelOnPosition(Level world, BlockPos pos) {
        if (!(world.m_8055_(pos = pos.m_7494_()).m_60734_() instanceof BeltTunnelBlock)) {
            return null;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be == null || !(be instanceof BeltTunnelBlockEntity)) {
            return null;
        }
        return (BeltTunnelBlockEntity)be;
    }
}

