/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ClientContraption {
    private final VirtualRenderWorld renderLevel;
    private final List<BlockEntity> renderedBlockEntities = new ArrayList<BlockEntity>();
    public final List<BlockEntity> renderedBlockEntityView = Collections.unmodifiableList(this.renderedBlockEntities);
    public final BitSet shouldRenderBlockEntities = new BitSet();
    public final BitSet scratchErroredBlockEntities = new BitSet();
    private final ContraptionMatrices matrices = new ContraptionMatrices();
    private final Contraption contraption;
    private int structureVersion = 0;
    private int childrenVersion = 0;

    public ClientContraption(Contraption contraption) {
        Level level = contraption.entity.m_9236_();
        this.contraption = contraption;
        BlockPos origin = contraption.anchor;
        int minY = VirtualRenderWorld.nextMultipleOf16(Mth.m_14107_((double)(contraption.bounds.f_82289_ - 1.0)));
        int height = VirtualRenderWorld.nextMultipleOf16(Mth.m_14165_((double)(contraption.bounds.f_82292_ + 1.0))) - minY;
        this.renderLevel = new VirtualRenderWorld(level, minY, height, (Vec3i)origin, this::invalidateStructure){

            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization((LevelAccessor)this.level);
            }
        };
        this.setupRenderLevelAndRenderedBlockEntities();
    }

    public int structureVersion() {
        return this.structureVersion;
    }

    public int childrenVersion() {
        return this.childrenVersion;
    }

    public void resetRenderLevel() {
        this.renderedBlockEntities.clear();
        this.renderLevel.clear();
        this.shouldRenderBlockEntities.clear();
        this.setupRenderLevelAndRenderedBlockEntities();
        this.invalidateStructure();
        this.invalidateChildren();
    }

    public void invalidateChildren() {
        ++this.childrenVersion;
    }

    public void invalidateStructure() {
        for (RenderType renderType : RenderType.m_110506_()) {
            SuperByteBufferCache.getInstance().invalidate(ContraptionEntityRenderer.CONTRAPTION, (Object)Pair.of((Object)this.contraption, (Object)renderType));
        }
        ++this.structureVersion;
    }

    private void setupRenderLevelAndRenderedBlockEntities() {
        for (StructureTemplate.StructureBlockInfo info : this.contraption.getBlocks().values()) {
            this.renderLevel.m_7731_(info.f_74675_(), info.f_74676_(), 0);
            BlockEntity blockEntity = this.readBlockEntity(this.renderLevel, info, this.contraption.getIsLegacy().getBoolean((Object)info.f_74675_()));
            if (blockEntity == null) continue;
            this.renderLevel.m_151523_(blockEntity);
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)info.f_74676_());
            if (movementBehaviour != null && movementBehaviour.disableBlockEntityRendering()) continue;
            this.renderedBlockEntities.add(blockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
        this.renderLevel.runLightEngine();
    }

    @Nullable
    public BlockEntity readBlockEntity(Level level, StructureTemplate.StructureBlockInfo info, boolean legacy) {
        Block block;
        BlockState state = info.f_74676_();
        BlockPos pos = info.f_74675_();
        CompoundTag nbt = info.f_74677_();
        if (legacy) {
            if (nbt == null) {
                return null;
            }
            nbt.m_128405_("x", pos.m_123341_());
            nbt.m_128405_("y", pos.m_123342_());
            nbt.m_128405_("z", pos.m_123343_());
            BlockEntity be = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)nbt);
            ClientContraption.postprocessReadBlockEntity(level, be, state);
            return be;
        }
        if (!state.m_155947_() || !((block = state.m_60734_()) instanceof EntityBlock)) {
            return null;
        }
        EntityBlock entityBlock = (EntityBlock)block;
        BlockEntity be = entityBlock.m_142194_(pos, state);
        ClientContraption.postprocessReadBlockEntity(level, be, state);
        if (be != null && nbt != null) {
            be.handleUpdateTag(nbt);
        }
        return be;
    }

    protected static void postprocessReadBlockEntity(Level level, @Nullable BlockEntity be, BlockState blockState) {
        if (be != null) {
            be.m_142339_(level);
            be.m_155250_(blockState);
            if (be instanceof KineticBlockEntity) {
                KineticBlockEntity kbe = (KineticBlockEntity)be;
                kbe.setSpeed(0.0f);
            }
        }
    }

    public VirtualRenderWorld getRenderLevel() {
        return this.renderLevel;
    }

    public ContraptionMatrices getMatrices() {
        return this.matrices;
    }

    public RenderedBlocks getRenderedBlocks() {
        return new RenderedBlocks(pos -> {
            StructureTemplate.StructureBlockInfo info = this.contraption.getBlocks().get(pos);
            if (info == null) {
                return Blocks.f_50016_.m_49966_();
            }
            return info.f_74676_();
        }, this.contraption.getBlocks().keySet());
    }

    public ModelData getModelData(BlockPos pos) {
        BlockEntity blockEntity = this.renderLevel.m_7702_(pos);
        if (blockEntity != null) {
            return blockEntity.getModelData();
        }
        return ModelData.EMPTY;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos localPos) {
        return this.renderLevel.m_7702_(localPos);
    }

    public BitSet getAndAdjustShouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public record RenderedBlocks(Function<BlockPos, BlockState> lookup, Iterable<BlockPos> positions) {
    }
}

