/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.aitforger.early;

import com.google.common.collect.ImmutableMap;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;

public class ForgerModLocator
extends AbstractJarFileModLocator {
    private static final Path SELF_PATH = (Path)LamdbaExceptionUtils.uncheck(() -> {
        URL jarLocation = ForgerModLocator.class.getProtectionDomain().getCodeSource().getLocation();
        return Path.of(jarLocation.toURI());
    });
    private static final String[] EMBEDDED = new String[]{"bootstrap.jar", "remapped.jar", "shim.jar"};
    private static final String JIJ_PREFIX = "META-INF/jarjar/";

    public Stream<Path> scanCandidates() {
        return Stream.of(EMBEDDED).map(LamdbaExceptionUtils.rethrowFunction(ForgerModLocator::getJarInJar));
    }

    public String name() {
        return "aitforger_mod_locator";
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    private static Path getJarInJar(String name) throws IOException, URISyntaxException {
        Path pathInModFile = SELF_PATH.resolve(JIJ_PREFIX).resolve(name);
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        return zipFS.getPath("/", new String[0]);
    }
}

