/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.aitforger.early;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EnvironmentStripper
implements ILaunchPluginService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker ENVXFORM = MarkerFactory.getMarker((String)"ENVXFORM");
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private static final String ENVIRONMENT = "Lnet/fabricmc/api/Environment;";
    private static final Supplier<Dist> SUPPLIER = () -> FMLEnvironment.dist;
    private Dist dist;

    private Dist dist() {
        return this.dist != null ? this.dist : (this.dist = SUPPLIER.get());
    }

    public String name() {
        return "envstripper";
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        AtomicBoolean changes = new AtomicBoolean();
        classNode.methods.removeIf(method -> this.iterMethods(method.invisibleAnnotations, classNode, (MethodNode)method, changes));
        classNode.fields.removeIf(field -> this.iterFields(field.invisibleAnnotations, classNode, (FieldNode)field, changes));
        return changes.get() ? 256 : 0;
    }

    private boolean iterFields(List<AnnotationNode> nodes, ClassNode classNode, FieldNode field, AtomicBoolean changes) {
        if (nodes == null) {
            return false;
        }
        for (AnnotationNode annotation : nodes) {
            Dist targetEnv;
            if (!annotation.desc.equals(ENVIRONMENT) || (targetEnv = EnvironmentStripper.getDist(annotation)) == this.dist()) continue;
            changes.compareAndSet(false, true);
            LOGGER.warn(ENVXFORM, "Removing field '{}' from {}", (Object)field.name, (Object)classNode.name);
            return true;
        }
        return false;
    }

    private boolean iterMethods(List<AnnotationNode> nodes, ClassNode classNode, MethodNode method, AtomicBoolean changes) {
        if (nodes == null) {
            return false;
        }
        for (AnnotationNode annotation : nodes) {
            Dist targetEnv;
            if (!annotation.desc.equals(ENVIRONMENT) || (targetEnv = EnvironmentStripper.getDist(annotation)) == this.dist()) continue;
            changes.compareAndSet(false, true);
            LOGGER.warn(ENVXFORM, "Removing method '{}' from {}", (Object)method.name, (Object)classNode.name);
            return true;
        }
        return false;
    }

    private static Dist getDist(AnnotationNode node) {
        Object[] arr = (Object[])node.values.get(1);
        String side = (String)arr[1];
        return side.equals("CLIENT") ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    public Consumer<Dist> getExtension() {
        return s -> {};
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return isEmpty || this.dist() == Dist.CLIENT || !classType.getInternalName().startsWith("dev/amble/ait") ? NAY : YAY;
    }
}

