/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsmenutweaks.module;

import com.yungnickyoung.minecraft.yungsmenutweaks.YungsMenuTweaksCommon;
import com.yungnickyoung.minecraft.yungsmenutweaks.config.YMTConfigForge;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ConfigModuleForge {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)YMTConfigForge.SPEC, "yungsmenutweaks-forge-1_20_1.toml");
        MinecraftForge.EVENT_BUS.addListener(ConfigModuleForge::onWorldLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigModuleForge::onConfigChange);
    }

    private static void onWorldLoad(LevelEvent.Load event) {
        ConfigModuleForge.bakeConfig();
    }

    private static void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == YMTConfigForge.SPEC) {
            ConfigModuleForge.bakeConfig();
        }
    }

    private static void bakeConfig() {
        YungsMenuTweaksCommon.CONFIG.enableRightClickCycleButton = (Boolean)YMTConfigForge.enableRightClickCycleButton.get();
        YungsMenuTweaksCommon.CONFIG.enableMouseScrollOnSliders = (Boolean)YMTConfigForge.enableMouseScrollOnSliders.get();
        YungsMenuTweaksCommon.CONFIG.enableBackgroundTexture = (Boolean)YMTConfigForge.enableBackgroundTexture.get();
        ResourceLocation backgroundTexture = ResourceLocation.m_135820_((String)((String)YMTConfigForge.backgroundTexture.get()));
        if (backgroundTexture != null) {
            YungsMenuTweaksCommon.CONFIG.backgroundTexture = backgroundTexture;
        } else {
            YungsMenuTweaksCommon.LOGGER.error("Invalid background texture path: " + (String)YMTConfigForge.backgroundTexture.get());
            YungsMenuTweaksCommon.LOGGER.error("Using default background texture path instead: textures/block/dirt.png");
            YungsMenuTweaksCommon.CONFIG.backgroundTexture = new ResourceLocation("textures/block/dirt.png");
        }
    }
}

