/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public final class IafConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_DRAGON_ROOST = IafConfiguredFeatures.registerKey("fire_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_DRAGON_ROOST = IafConfiguredFeatures.registerKey("ice_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_DRAGON_ROOST = IafConfiguredFeatures.registerKey("lightning_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_DRAGON_CAVE = IafConfiguredFeatures.registerKey("fire_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_DRAGON_CAVE = IafConfiguredFeatures.registerKey("ice_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_DRAGON_CAVE = IafConfiguredFeatures.registerKey("lightning_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CYCLOPS_CAVE = IafConfiguredFeatures.registerKey("cyclops_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PIXIE_VILLAGE = IafConfiguredFeatures.registerKey("pixie_village");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SIREN_ISLAND = IafConfiguredFeatures.registerKey("siren_island");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HYDRA_CAVE = IafConfiguredFeatures.registerKey("hydra_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYRMEX_HIVE_DESERT = IafConfiguredFeatures.registerKey("myrmex_hive_desert");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYRMEX_HIVE_JUNGLE = IafConfiguredFeatures.registerKey("myrmex_hive_jungle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DEATH_WORM = IafConfiguredFeatures.registerKey("spawn_death_worm");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_L = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_lightning");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_F = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_fire");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_I = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_ice");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_HIPPOCAMPUS = IafConfiguredFeatures.registerKey("spawn_hippocampus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_SEA_SERPENT = IafConfiguredFeatures.registerKey("spawn_sea_serpent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_STYMPHALIAN_BIRD = IafConfiguredFeatures.registerKey("spawn_stymphalian_bird");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_WANDERING_CYCLOPS = IafConfiguredFeatures.registerKey("spawn_wandering_cyclops");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = IafConfiguredFeatures.registerKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE = IafConfiguredFeatures.registerKey("sapphire_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_LILY = IafConfiguredFeatures.registerKey("fire_lily");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROST_LILY = IafConfiguredFeatures.registerKey("frost_lily");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_LILY = IafConfiguredFeatures.registerKey("lightning_lily");
    private static Function<Block, RandomPatchConfiguration> flowerConf = block -> FeatureUtils.m_206470_((int)8, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.m_49966_().m_60734_()))));

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("iceandfire", name));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        context.m_255272_(FIRE_DRAGON_ROOST, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.FIRE_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(ICE_DRAGON_ROOST, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.ICE_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(LIGHTNING_DRAGON_ROOST, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.LIGHTNING_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(FIRE_DRAGON_CAVE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.FIRE_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(ICE_DRAGON_CAVE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.ICE_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(LIGHTNING_DRAGON_CAVE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.LIGHTNING_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(CYCLOPS_CAVE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.CYCLOPS_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(PIXIE_VILLAGE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.PIXIE_VILLAGE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SIREN_ISLAND, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SIREN_ISLAND.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(HYDRA_CAVE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.HYDRA_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(MYRMEX_HIVE_DESERT, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.MYRMEX_HIVE_DESERT.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(MYRMEX_HIVE_JUNGLE, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.MYRMEX_HIVE_JUNGLE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_DEATH_WORM, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DEATH_WORM.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_DRAGON_SKELETON_L, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_L.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_DRAGON_SKELETON_F, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_F.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_DRAGON_SKELETON_I, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_I.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_HIPPOCAMPUS, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_HIPPOCAMPUS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_SEA_SERPENT, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_SEA_SERPENT.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_STYMPHALIAN_BIRD, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_STYMPHALIAN_BIRD.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(SPAWN_WANDERING_CYCLOPS, (Object)new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_WANDERING_CYCLOPS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        TagMatchTest stoneOreRule = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateOreRule = new TagMatchTest(BlockTags.f_144267_);
        List<OreConfiguration.TargetBlockState> silverOreConfiguration = List.of(OreConfiguration.m_161021_((RuleTest)stoneOreRule, (BlockState)((Block)IafBlockRegistry.SILVER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOreRule, (BlockState)((Block)IafBlockRegistry.DEEPSLATE_SILVER_ORE.get()).m_49966_()));
        context.m_255272_(SILVER_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(silverOreConfiguration, 4)));
        context.m_255272_(SAPPHIRE_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)IafBlockRegistry.SAPPHIRE_ORE.get()).m_49966_(), 4, 0.5f)));
        context.m_255272_(FIRE_LILY, (Object)new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.FIRE_LILY.get())));
        context.m_255272_(FROST_LILY, (Object)new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.FROST_LILY.get())));
        context.m_255272_(LIGHTNING_LILY, (Object)new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.LIGHTNING_LILY.get())));
    }
}

