/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.iceandfire.client.model.ModelDreadBase;
import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ModelDreadLich
extends ModelDreadBase<EntityDreadLich>
implements ArmedModel {
    public HideableModelRenderer robe;
    public HideableModelRenderer mask;
    public HideableModelRenderer hood;
    public HideableModelRenderer sleeveRight;
    public HideableModelRenderer robeLowerRight;
    public HideableModelRenderer robeLowerLeft;
    public HideableModelRenderer sleeveLeft;

    public ModelDreadLich(float modelScale) {
        this.texWidth = 128;
        this.texHeight = 64;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.sleeveLeft = new HideableModelRenderer(this, 33, 35);
        this.sleeveLeft.mirror = true;
        this.sleeveLeft.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveLeft.addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelScale);
        this.robeLowerRight = new HideableModelRenderer(this, 48, 35);
        this.robeLowerRight.mirror = true;
        this.robeLowerRight.setPos(0.0f, 0.0f, 0.0f);
        this.robeLowerRight.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.legLeft = new HideableModelRenderer(this, 0, 16);
        this.legLeft.mirror = true;
        this.legLeft.setPos(2.0f, 12.0f, 0.1f);
        this.legLeft.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelScale);
        this.robe = new HideableModelRenderer(this, 4, 34);
        this.robe.setPos(0.0f, 0.1f, 0.0f);
        this.robe.addBox(-4.5f, 0.0f, -2.5f, 9.0f, 12.0f, 5.0f, modelScale);
        this.legRight = new HideableModelRenderer(this, 0, 16);
        this.legRight.setPos(-2.0f, 12.0f, 0.1f);
        this.legRight.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelScale);
        this.sleeveRight = new HideableModelRenderer(this, 33, 35);
        this.sleeveRight.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveRight.addBox(-2.2f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelScale);
        this.mask = new HideableModelRenderer(this, 40, 6);
        this.mask.setPos(0.0f, 0.0f, 0.0f);
        this.mask.addBox(-3.5f, -10.0f, -4.1f, 7.0f, 8.0f, 0.0f, modelScale);
        this.armRight = new HideableModelRenderer(this, 40, 16);
        this.armRight.setPos(-5.0f, 2.0f, 0.0f);
        this.armRight.addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelScale);
        this.setRotateAngle(this.armRight, 0.0f, -0.10000736f, 0.10000736f);
        this.hood = new HideableModelRenderer(this, 60, 0);
        this.hood.setPos(0.0f, 0.0f, 0.0f);
        this.hood.addBox(-4.5f, -8.6f, -4.5f, 9.0f, 9.0f, 9.0f, modelScale);
        this.head = new HideableModelRenderer(this, 0, 0);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelScale);
        this.body = new HideableModelRenderer(this, 16, 16);
        this.body.setPos(0.0f, 0.0f, 0.0f);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelScale);
        this.armLeft = new HideableModelRenderer(this, 40, 16);
        this.armLeft.mirror = true;
        this.armLeft.setPos(5.0f, 2.0f, -0.0f);
        this.armLeft.addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelScale);
        this.setRotateAngle(this.armLeft, 0.0f, 0.10000736f, -0.10000736f);
        this.robeLowerLeft = new HideableModelRenderer(this, 48, 35);
        this.robeLowerLeft.setPos(0.0f, 0.0f, 0.0f);
        this.robeLowerLeft.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.armLeft.addChild((BasicModelPart)this.sleeveLeft);
        this.legRight.addChild((BasicModelPart)this.robeLowerRight);
        this.body.addChild((BasicModelPart)this.legLeft);
        this.body.addChild((BasicModelPart)this.robe);
        this.body.addChild((BasicModelPart)this.legRight);
        this.armRight.addChild((BasicModelPart)this.sleeveRight);
        this.head.addChild((BasicModelPart)this.mask);
        this.body.addChild((BasicModelPart)this.armRight);
        this.head.addChild((BasicModelPart)this.hood);
        this.body.addChild((BasicModelPart)this.head);
        this.body.addChild((BasicModelPart)this.armLeft);
        this.legLeft.addChild((BasicModelPart)this.robeLowerLeft);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void setLivingAnimations(EntityDreadThrall LivingEntityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = LivingEntityIn.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41720_() == Items.f_42411_) {
            if (LivingEntityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @Override
    public Animation getSpawnAnimation() {
        return EntityDreadLich.ANIMATION_SPAWN;
    }

    @Override
    public void setupAnim(EntityDreadLich entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entityIn.getAnimation() == EntityDreadLich.ANIMATION_SUMMON) {
            this.armRight.rotationPointZ = 0.0f;
            this.armRight.rotationPointX = -5.0f;
            this.armLeft.rotationPointZ = 0.0f;
            this.armLeft.rotationPointX = 5.0f;
            this.armRight.rotateAngleX = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.armLeft.rotateAngleX = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.armRight.rotateAngleZ = 2.3561945f;
            this.armLeft.rotateAngleZ = -2.3561945f;
            this.armRight.rotateAngleY = 0.0f;
            this.armLeft.rotateAngleY = 0.0f;
        }
    }
}

