/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.ClientProxy;
import com.github.alexthe666.iceandfire.client.gui.MyrmexDeleteButton;
import com.github.alexthe666.iceandfire.client.gui.bestiary.ChangePageButton;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageGetMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiMyrmexStaff
extends Screen {
    private static final ResourceLocation JUNGLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_jungle.png");
    private static final ResourceLocation DESERT_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_desert.png");
    private static final WorldGenMyrmexHive.RoomType[] ROOMS = new WorldGenMyrmexHive.RoomType[]{WorldGenMyrmexHive.RoomType.FOOD, WorldGenMyrmexHive.RoomType.NURSERY, WorldGenMyrmexHive.RoomType.EMPTY};
    private static final int ROOMS_PER_PAGE = 5;
    private final List<Room> allRoomPos = Lists.newArrayList();
    private final List<MyrmexDeleteButton> allRoomButtonPos = Lists.newArrayList();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    int ticksSinceDeleted = 0;
    int currentPage = 0;
    private final boolean jungle;
    private int hiveCount;

    public GuiMyrmexStaff(ItemStack staff) {
        super((Component)Component.m_237115_((String)"myrmex_staff_screen"));
        this.jungle = staff.m_41720_() == IafItemRegistry.MYRMEX_JUNGLE_STAFF.get();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_169369_.clear();
        this.allRoomButtonPos.clear();
        int i = (this.f_96543_ - 248) / 2;
        int j = (this.f_96544_ - 166) / 2;
        int x_translate = 193;
        int y_translate = 37;
        if (ClientProxy.getReferedClientHive() == null) {
            return;
        }
        this.populateRoomMap();
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)(ClientProxy.getReferedClientHive().reproduces ? Component.m_237115_((String)"myrmex.message.disablebreeding") : Component.m_237115_((String)"myrmex.message.enablebreeding")), p_214132_1_ -> {
            boolean opposite;
            ClientProxy.getReferedClientHive().reproduces = opposite = !ClientProxy.getReferedClientHive().reproduces;
        }).m_252794_(i + 124, j + 15).m_253046_(120, 20).m_253136_());
        this.previousPage = new ChangePageButton(i + 5, j + 150, false, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        });
        this.m_7787_((GuiEventListener)this.previousPage);
        this.nextPage = new ChangePageButton(i + 225, j + 150, true, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage < this.allRoomButtonPos.size() / 5) {
                ++this.currentPage;
            }
        });
        this.m_7787_((GuiEventListener)this.nextPage);
        int totalRooms = this.allRoomPos.size();
        for (int rooms = 0; rooms < this.allRoomPos.size(); ++rooms) {
            int yIndex = rooms % 5;
            BlockPos pos = this.allRoomPos.get((int)rooms).pos;
            MyrmexDeleteButton button = new MyrmexDeleteButton(i + x_translate, j + y_translate + yIndex * 22, pos, (Component)Component.m_237115_((String)"myrmex.message.delete"), p_214132_1_ -> {
                if (this.ticksSinceDeleted <= 0) {
                    ClientProxy.getReferedClientHive().removeRoom(pos);
                    this.ticksSinceDeleted = 5;
                }
            });
            button.f_93624_ = rooms < 5 * (this.currentPage + 1) && rooms >= 5 * this.currentPage;
            this.m_7787_((GuiEventListener)button);
            this.allRoomButtonPos.add(button);
        }
        if (totalRooms <= 5 * this.currentPage && this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private void populateRoomMap() {
        this.allRoomPos.clear();
        for (WorldGenMyrmexHive.RoomType type : ROOMS) {
            List<BlockPos> roomPos = ClientProxy.getReferedClientHive().getRooms(type);
            for (BlockPos pos : roomPos) {
                String name = type == WorldGenMyrmexHive.RoomType.FOOD ? "food" : (type == WorldGenMyrmexHive.RoomType.NURSERY ? "nursery" : "misc");
                this.allRoomPos.add(new Room(pos, name));
            }
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntrances().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_surface"));
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntranceBottoms().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_bottom"));
        }
    }

    public void m_280273_(@NotNull GuiGraphics ms) {
        super.m_280273_(ms);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.f_96543_ - 248) / 2;
        int j = (this.f_96544_ - 166) / 2;
        ms.m_280218_(this.jungle ? JUNGLE_TEXTURE : DESERT_TEXTURE, i, j, 0, 0, 248, 166);
    }

    public void m_88315_(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        int color;
        this.m_280273_(ms);
        this.m_7856_();
        int i = (this.f_96543_ - 248) / 2 + 10;
        int j = (this.f_96544_ - 166) / 2 + 8;
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        int n = color = this.jungle ? 3533333 : 0xFFBF00;
        if (this.ticksSinceDeleted > 0) {
            --this.ticksSinceDeleted;
        }
        this.hiveCount = 0;
        for (int rooms = 0; rooms < this.allRoomButtonPos.size(); ++rooms) {
            if (rooms >= 5 * (this.currentPage + 1) || rooms < 5 * this.currentPage) continue;
            this.drawRoomInfo(ms, this.allRoomPos.get((int)rooms).string, this.allRoomPos.get((int)rooms).pos, i, j, color);
        }
        if (ClientProxy.getReferedClientHive() != null) {
            if (!ClientProxy.getReferedClientHive().colonyName.isEmpty()) {
                String title = I18n.m_118938_((String)"myrmex.message.colony_named", (Object[])new Object[]{ClientProxy.getReferedClientHive().colonyName});
                this.getMinecraft().f_91062_.m_271703_(title, (float)(i + 40 - title.length() / 2), (float)(j - 3), color, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            } else {
                this.getMinecraft().f_91062_.m_271703_(I18n.m_118938_((String)"myrmex.message.colony", (Object[])new Object[0]), (float)(i + 80), (float)(j - 3), color, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            int opinion = ClientProxy.getReferedClientHive().getPlayerReputation(Minecraft.m_91087_().f_91074_.m_20148_());
            this.getMinecraft().f_91062_.m_271703_(I18n.m_118938_((String)"myrmex.message.hive_opinion", (Object[])new Object[]{opinion}), (float)i, (float)(j + 12), color, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            this.getMinecraft().f_91062_.m_271703_(I18n.m_118938_((String)"myrmex.message.rooms", (Object[])new Object[0]), (float)i, (float)(j + 25), color, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void m_7861_() {
        if (ClientProxy.getReferedClientHive() != null) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageGetMyrmexHive(ClientProxy.getReferedClientHive().toNBT()));
        }
    }

    private void drawRoomInfo(GuiGraphics ms, String type, BlockPos pos, int i, int j, int color) {
        String translate = "myrmex.message.room." + type;
        this.getMinecraft().f_91062_.m_271703_(I18n.m_118938_((String)translate, (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), (float)i, (float)(j + 36 + this.hiveCount * 22), color, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ++this.hiveCount;
    }

    private class Room {
        public BlockPos pos;
        public String string;

        public Room(BlockPos pos, String string) {
            this.pos = pos;
            this.string = string;
        }
    }
}

