/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidSnapshot;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public record PlatformBlockFluidHandler(IFluidHandler handler) implements FluidContainer
{
    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        return this.handler.fill(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        return new ForgeFluidHolder(this.handler.drain(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        FluidStack fluidInTank = this.handler.getFluidInTank(slot);
        this.handler.drain(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
        this.handler.fill(new ForgeFluidHolder(fluid).getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public List<FluidHolder> getFluids() {
        ArrayList<FluidHolder> fluids = new ArrayList<FluidHolder>();
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            fluids.add(new ForgeFluidHolder(this.handler.getFluidInTank(i)));
        }
        return fluids;
    }

    @Override
    public int getSize() {
        return this.handler.getTanks();
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            if (this.handler.getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public FluidContainer copy() {
        throw new UnsupportedOperationException("Copying is not supported on PlatformFluidContainers");
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        throw new UnsupportedOperationException("Copying is not supported on PlatformFluidContainers");
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        return 0L;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public boolean isFluidValid(int slot, FluidHolder fluid) {
        return this.handler.isFluidValid(slot, new ForgeFluidHolder(fluid).getFluidStack());
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        return nbt;
    }

    public void m_6211_() {
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            this.handler.drain(this.handler.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

