/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.forge.energy.PlatformBlockEnergyManager;
import earth.terrarium.botarium.forge.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.util.Updatable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class EnergyApi {
    private static final Map<Supplier<BlockEntityType<?>>, BlockEnergyGetter<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Block>, BlockEnergyGetter<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Item>, ItemEnergyGetter<?>> ITEM_LOOKUP_MAP = new HashMap();
    public static final Map<BlockEntityType<?>, BlockEnergyGetter<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    public static final Map<Block, BlockEnergyGetter<?>> FINALIZED_BLOCK_LOOKUP_MAP = new HashMap();
    public static boolean blocksFinalized = false;
    public static final Map<Item, ItemEnergyGetter<?>> FINALIZED_ITEM_LOOKUP_MAP = new HashMap();
    public static boolean itemsFinalized = false;

    public static void finalizeBlockRegistration() {
        if (!blocksFinalized) {
            System.out.println("Finalizing energy block registration");
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockEnergyGetter<?>> entry : BLOCK_ENTITY_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockEnergyGetter<?>> entry : BLOCK_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_LOOKUP_MAP.put((Block)entry.getKey().get(), entry.getValue());
            }
            blocksFinalized = true;
        }
    }

    public static void finalizeItemRegistration() {
        if (!itemsFinalized) {
            System.out.println("Finalizing energy item registration");
            for (Map.Entry<Supplier<Item>, ItemEnergyGetter<?>> entry : ITEM_LOOKUP_MAP.entrySet()) {
                FINALIZED_ITEM_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            itemsFinalized = true;
        }
    }

    public static void registerEnergyBlockEntity(Supplier<BlockEntityType<?>> block, BlockEnergyGetter<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlockEntity(BlockEnergyGetter<?> getter, Supplier<BlockEntityType<?>> ... blocks) {
        for (Supplier<BlockEntityType<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyBlock(Supplier<Block> block, BlockEnergyGetter<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlock(BlockEnergyGetter<?> getter, Supplier<Block> ... blocks) {
        for (Supplier<Block> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyItem(Supplier<Item> item, ItemEnergyGetter<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerEnergyItem(ItemEnergyGetter<?> getter, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    @Nullable
    public static EnergyContainer getItemEnergyContainer(ItemStackHolder stack) {
        return stack.getStack().getCapability(ForgeCapabilities.ENERGY).isPresent() ? new PlatformItemEnergyManager(stack) : null;
    }

    @Nullable
    public static EnergyContainer getBlockEnergyContainer(BlockEntity entity, @Nullable Direction direction) {
        return entity.getCapability(ForgeCapabilities.ENERGY, direction).isPresent() ? new PlatformBlockEnergyManager((CapabilityProvider<?>)entity, direction) : null;
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean isEnergyBlock(BlockEntity block, @Nullable Direction direction) {
        return block.getCapability(ForgeCapabilities.ENERGY, direction).isPresent();
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, @Nullable Direction extractDirection, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.m_58904_(), energyBlock.m_58899_(), extractDirection, amount);
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.m_58904_(), energyBlock.m_58899_(), null, amount);
    }

    public static long distributeEnergyNearby(Level level, BlockPos energyPos, @Nullable Direction extractDirection, long amount) {
        EnergyContainer internalEnergy = EnergyContainer.of(level, energyPos, extractDirection);
        long amountToDistribute = internalEnergy.extractEnergy(amount, true);
        if (amountToDistribute == 0L) {
            return 0L;
        }
        List<EnergyContainer> list = Direction.m_235666_().map(direction -> EnergyContainer.of(level, energyPos.m_121945_(direction), direction.m_122424_())).filter(Objects::nonNull).sorted(Comparator.comparingLong(energy -> energy.insertEnergy(amount, true))).toList();
        int receiverCount = list.size();
        for (EnergyContainer energy2 : list) {
            if (energy2 == null) continue;
            long inserted = EnergyApi.moveEnergy(internalEnergy, energy2, amountToDistribute / (long)receiverCount, false);
            amountToDistribute -= inserted;
            --receiverCount;
        }
        return amount - amountToDistribute;
    }

    public static long moveEnergy(EnergyContainer from, EnergyContainer to, long amount, boolean simulate) {
        long extracted = from.extractEnergy(amount, true);
        long inserted = to.insertEnergy(extracted, true);
        long simulatedExtraction = from.extractEnergy(inserted, true);
        if (!simulate && inserted > 0L && simulatedExtraction == inserted) {
            from.extractEnergy(inserted, false);
            to.insertEnergy(inserted, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveEnergy(ItemStackHolder from, ItemStackHolder to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyItem(from.getStack()) || !EnergyApi.isEnergyItem(to.getStack())) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getItemEnergyContainer(from);
        EnergyContainer toEnergy = EnergyApi.getItemEnergyContainer(to);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, BlockEntity to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyBlock(from, null) || !EnergyApi.isEnergyBlock(to, null)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getBlockEnergyContainer(from, null);
        EnergyContainer toEnergy = EnergyApi.getBlockEnergyContainer(to, null);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(Level level, BlockPos fromPos, @Nullable Direction fromDirection, BlockPos toPos, @Nullable Direction toDirection, long amount, boolean simulate) {
        if (!EnergyContainer.holdsEnergy(level, fromPos, fromDirection) || !EnergyContainer.holdsEnergy(level, toPos, toDirection)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyContainer.of(level, fromPos, fromDirection);
        EnergyContainer toEnergy = EnergyContainer.of(level, toPos, toDirection);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, Direction direction, ItemStackHolder to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyBlock(from, direction) || !EnergyApi.isEnergyItem(to.getStack())) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getBlockEnergyContainer(from, direction);
        EnergyContainer toEnergy = EnergyApi.getItemEnergyContainer(to);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(ItemStackHolder from, BlockEntity to, Direction direction, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyItem(from.getStack()) || !EnergyApi.isEnergyBlock(to, direction)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getItemEnergyContainer(from);
        EnergyContainer toEnergy = EnergyApi.getBlockEnergyContainer(to, direction);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    @FunctionalInterface
    public static interface BlockEnergyGetter<T extends EnergyContainer & Updatable<BlockEntity>> {
        public T getEnergyContainer(Level var1, BlockPos var2, BlockState var3, BlockEntity var4, Direction var5);
    }

    @FunctionalInterface
    public static interface ItemEnergyGetter<T extends EnergyContainer & Updatable<ItemStack>> {
        public T getEnergyContainer(ItemStack var1);
    }
}

