/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.util;

import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.util.CommonConfig;
import net.minecraft.world.entity.player.Player;

public class ProjectileReflectionHelper {
    public static void tickReflectCharges(Player player) {
        int[] reflections = ProjectileReflectionHelper.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] <= 0) continue;
            int n = i;
            reflections[n] = reflections[n] - 1;
        }
        ProjectileReflectionHelper.updateReflectCharges(player, reflections);
    }

    public static boolean consumeReflectCharge(Player player) {
        int[] reflections = ProjectileReflectionHelper.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] > 0) continue;
            reflections[i] = (Integer)CommonConfig.PROJECTILE_REFLECTION_TICKS_PER_CHARGE.get();
            ProjectileReflectionHelper.updateReflectCharges(player, reflections);
            return true;
        }
        return false;
    }

    private static int[] getReflectCharges(Player player) {
        int[] reflections = !player.getPersistentData().m_128441_("dragon_mage_armor_reflect_counters") ? new int[ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.PROJECTILE_REFLECTION)] : player.getPersistentData().m_128465_("dragon_mage_armor_reflect_counters");
        if (reflections.length != ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.PROJECTILE_REFLECTION)) {
            reflections = new int[Integer.valueOf(ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.PROJECTILE_REFLECTION)).intValue()];
        }
        return reflections;
    }

    private static void updateReflectCharges(Player player, int[] reflections) {
        player.getPersistentData().m_128385_("dragon_mage_armor_reflect_counters", reflections);
    }
}

