/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.shape;

import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.spells.shapes.ShapeRaytrace;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TrueTouchShape
extends ShapeRaytrace {
    public TrueTouchShape(ResourceLocation icon) {
        super(icon, new AttributeValuePair[]{new AttributeValuePair(Attribute.RANGE, 3.0f, 3.0f, 16.0f, 1.0f, 1.0f), new AttributeValuePair(Attribute.RADIUS, 0.0f, 0.0f, 3.0f, 1.0f)});
    }

    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        SpellTarget tgt;
        if (source.getCaster() != null && source.getCaster().m_6144_()) {
            return List.of(new SpellTarget((Entity)source.getCaster()));
        }
        List<SpellTarget> targets = super.Target(source, world, modificationData, recipe);
        int radius = (int)Math.floor(modificationData.getValue(Attribute.RADIUS));
        if (radius > 0 && (tgt = (SpellTarget)targets.get(0)) != SpellTarget.NONE) {
            if (tgt.isBlock()) {
                targets = this.targetBlocksRadius(tgt, radius);
            } else if (tgt.isEntity()) {
                targets = this.targetBlocksEntity(source, tgt, radius, world);
            }
        }
        return targets;
    }

    private List<SpellTarget> targetBlocksRadius(SpellTarget origin, int radius) {
        Direction face = origin.getBlockFace(null);
        BlockPos targetPos = origin.getBlock();
        if (face == null) {
            return List.of(SpellTarget.NONE);
        }
        ArrayList<SpellTarget> targets = new ArrayList<SpellTarget>();
        if (face.m_122434_() != Direction.Axis.X && face.m_122434_() != Direction.Axis.Z) {
            for (int h = -radius; h <= radius; ++h) {
                for (int y = -radius; y <= radius; ++y) {
                    targets.add(new SpellTarget(targetPos.m_7918_(h, 0, y), face));
                }
            }
        } else {
            for (int h = -radius; h <= radius; ++h) {
                for (int y = -1; y <= 2 * radius - 1; ++y) {
                    if (face.m_122434_() == Direction.Axis.X) {
                        targets.add(new SpellTarget(targetPos.m_7918_(0, y, h), face));
                        continue;
                    }
                    targets.add(new SpellTarget(targetPos.m_7918_(h, y, 0), face));
                }
            }
        }
        return targets;
    }

    private List<SpellTarget> targetBlocksEntity(SpellSource source, SpellTarget center, int radius, Level world) {
        return world.m_6249_((Entity)source.getCaster(), center.getEntity().m_20191_().m_82400_((double)radius), entity -> entity.m_6087_() && entity.m_6084_() && entity != source.getCaster()).stream().map(SpellTarget::new).collect(Collectors.toList());
    }

    public float initialComplexity() {
        return 15.0f;
    }

    public int requiredXPForRote() {
        return 500;
    }
}

