/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.shape;

import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import de.joh.dmnr.common.init.ItemInit;
import de.joh.dmnr.common.item.BraceletOfFriendshipItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class FriendsShape
extends Shape {
    public FriendsShape(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.RANGE, 2.0f, 1.0f, 10.0f, 1.0f, 2.0f)});
    }

    public List<SpellTarget> Target(SpellSource source, Level level, IModifiedSpellPart<Shape> modifiedSpellPart, ISpellDefinition iSpellDefinition) {
        LivingEntity caster = source.getCaster();
        if (caster != null) {
            if (CuriosApi.getCuriosHelper().findFirstCurio(caster, (Item)ItemInit.BRACELET_OF_FRIENDSHIP.get()).isPresent()) {
                Stream<Object> friendsSteam = CuriosApi.getCuriosHelper().findCurios(caster, (Item)ItemInit.BRACELET_OF_FRIENDSHIP.get()).stream().map(SlotResult::stack).filter(item -> item.m_41720_() instanceof BraceletOfFriendshipItem).flatMap(stack -> Arrays.stream(((BraceletOfFriendshipItem)stack.m_41720_()).getPlayerTargets((ItemStack)stack, level)));
                if (caster instanceof Player) {
                    friendsSteam = Stream.concat(friendsSteam, Stream.of((Player)caster));
                }
                List friends = friendsSteam.toList();
                List<SpellTarget> inArea = level.m_6249_((Entity)source.getCaster(), caster.m_20191_().m_82400_((double)modifiedSpellPart.getValue(Attribute.RANGE)), entity -> entity.m_6087_() && entity.m_6084_() && entity != source.getCaster()).stream().map(SpellTarget::new).toList();
                ArrayList<SpellTarget> targets = new ArrayList<SpellTarget>();
                block0: for (SpellTarget target : inArea) {
                    for (Player friend : friends) {
                        if (friend != BraceletOfFriendshipItem.playerOrOwner(target.getEntity())) continue;
                        targets.add(target);
                        continue block0;
                    }
                }
                targets.add(new SpellTarget((Entity)caster));
                return targets;
            }
            if (caster instanceof Player) {
                ((Player)caster).m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.friends.no_bracelet_of_friendship.error"), true);
            }
        }
        return List.of(SpellTarget.NONE);
    }

    public float initialComplexity() {
        return 20.0f;
    }

    public int requiredXPForRote() {
        return 200;
    }
}

