/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.shape;

import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.items.ritual.PlayerCharm;
import de.joh.dmnr.common.init.ItemInit;
import de.joh.dmnr.common.item.CurseProtectionAmuletItem;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CurseShape
extends Shape {
    public CurseShape(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.RANGE, 1.0f, 1.0f, 10.0f, 1.0f, 10.0f)});
    }

    public List<SpellTarget> Target(SpellSource source, Level level, IModifiedSpellPart<Shape> modifiedSpellPart, ISpellDefinition iSpellDefinition) {
        LivingEntity caster = source.getCaster();
        if (caster != null) {
            ItemStack playerCharm;
            ItemStack itemStack = playerCharm = caster.m_21205_().m_41720_() != com.mna.items.ItemInit.PLAYER_CHARM.get() ? caster.m_21206_() : caster.m_21205_();
            if (playerCharm.m_41720_() instanceof PlayerCharm) {
                Player target = ((PlayerCharm)playerCharm.m_41720_()).GetPlayerTarget(playerCharm, level);
                if (target != null) {
                    double maxDist;
                    double dist = source.getCaster().m_20183_().m_123331_((Vec3i)target.m_20183_());
                    if (!(dist > (maxDist = (double)(modifiedSpellPart.getValue(Attribute.RANGE) * 20.0f)) * maxDist)) {
                        if (!((CurseProtectionAmuletItem)((Object)ItemInit.CURSE_PROTECTION_AMULET.get())).isEquippedAndHasMana((LivingEntity)target, 120.0f, false)) {
                            playerCharm.m_41774_(1);
                            return List.of(new SpellTarget((Entity)target));
                        }
                        if (source.getPlayer() != null && !level.m_5776_()) {
                            source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.curse.protection.error"), true);
                        }
                    } else if (source.getPlayer() != null && !level.m_5776_()) {
                        source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.curse.too_far.error"), true);
                    }
                } else if (source.getPlayer() != null && !level.m_5776_()) {
                    source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.curse.no_target.error"), true);
                }
            } else if (source.getPlayer() != null && !level.m_5776_()) {
                source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.curse.no_charm.error"), true);
            }
        }
        return List.of(SpellTarget.NONE);
    }

    public float initialComplexity() {
        return 20.0f;
    }

    public int requiredXPForRote() {
        return 200;
    }
}

