/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.shape;

import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import de.joh.dmnr.api.util.MarkSave;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class AtMarkShape
extends Shape {
    public AtMarkShape(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.RADIUS, 0.0f, 0.0f, 3.0f, 1.0f), new AttributeValuePair(Attribute.RANGE, 1.0f, 1.0f, 5.0f, 1.0f, 50.0f)});
    }

    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition iSpellDefinition) {
        if (!world.m_5776_() && source.getCaster() != null) {
            MarkSave mark = MarkSave.getMark(source.getCaster(), world);
            if (mark != null && mark.getPosition() != null) {
                double maxDist;
                double dist = source.getCaster().m_20183_().m_123331_((Vec3i)mark.getPosition());
                if (!(dist > (maxDist = (double)(modificationData.getValue(Attribute.RANGE) * 500.0f)) * maxDist)) {
                    SpellTarget tgt;
                    List<Object> targets = new ArrayList<SpellTarget>();
                    targets.add(new SpellTarget(mark.getPosition(), mark.getDirection()));
                    int radius = (int)Math.floor(modificationData.getValue(Attribute.RADIUS));
                    if (radius > 0 && (tgt = (SpellTarget)targets.get(0)) != SpellTarget.NONE && tgt.isBlock()) {
                        targets = this.targetBlocksRadius(tgt, radius);
                    }
                    List<SpellTarget> targetsEntity = world.m_6249_((Entity)null, new AABB(mark.getPosition()).m_82400_((double)radius), entity -> entity.m_6087_() && entity.m_6084_() && entity != source.getCaster()).stream().map(SpellTarget::new).toList();
                    targets.addAll(targetsEntity);
                    return targets;
                }
                if (source.getPlayer() != null) {
                    source.getPlayer().m_5661_((Component)Component.m_237115_((String)"mna:components/recall.too_far"), true);
                }
            } else if (source.getPlayer() != null) {
                source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.atmark.nomark.error"), true);
            }
        }
        return List.of(SpellTarget.NONE);
    }

    private List<SpellTarget> targetBlocksRadius(SpellTarget origin, int radius) {
        Direction face = origin.getBlockFace(null);
        BlockPos targetPos = origin.getBlock();
        if (face == null) {
            return List.of(SpellTarget.NONE);
        }
        ArrayList<SpellTarget> targets = new ArrayList<SpellTarget>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    targets.add(new SpellTarget(targetPos.m_7918_(x, y, z), face));
                }
            }
        }
        return targets;
    }

    public float initialComplexity() {
        return 20.0f;
    }

    public int requiredXPForRote() {
        return 500;
    }
}

