/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.component;

import com.mna.api.affinity.Affinity;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.ritual.PlayerCharm;
import com.mna.items.runes.BookOfMarks;
import com.mna.items.runes.ItemRuneMarking;
import de.joh.dmnr.capabilities.dragonmagic.PlayerDragonMagicProvider;
import de.joh.dmnr.common.util.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MarkComponent
extends SpellEffect {
    public MarkComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        ItemStack markingRune;
        if (source.getCaster() == null) {
            return ComponentApplicationResult.FAIL;
        }
        ItemStack itemStack = markingRune = source.getCaster().m_21205_().m_41720_() != ItemInit.RUNE_MARKING.get() && source.getCaster().m_21205_().m_41720_() != ItemInit.BOOK_MARKS.get() ? source.getCaster().m_21206_() : source.getCaster().m_21205_();
        if (((Boolean)CommonConfig.MARK_SUPPORT_PLAYERCHARM.get()).booleanValue() && markingRune.m_41720_() == ItemInit.PLAYER_CHARM.get()) {
            LivingEntity livingEntity = target.getLivingEntity();
            if (livingEntity instanceof Player) {
                Player playerTarget = (Player)livingEntity;
                ((PlayerCharm)ItemInit.PLAYER_CHARM.get()).SetPlayerTarget(playerTarget, markingRune);
                return ComponentApplicationResult.SUCCESS;
            }
            if (source.getPlayer() == null) return ComponentApplicationResult.FAIL;
            source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr:components/alternativerecall.no_player"), true);
            return ComponentApplicationResult.FAIL;
        }
        if (markingRune.m_41720_() != ItemInit.RUNE_MARKING.get() && markingRune.m_41720_() != ItemInit.BOOK_MARKS.get()) {
            if (source.getPlayer() == null) return ComponentApplicationResult.FAIL;
            source.getPlayer().getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(magic -> magic.mark(target.getBlock(), target.getBlockFace(null), context.getLevel()));
            return ComponentApplicationResult.SUCCESS;
        }
        MarkComponent.setPos(markingRune, target.getBlock(), target.getBlockFace(null), context.getLevel());
        return ComponentApplicationResult.SUCCESS;
    }

    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    public float initialComplexity() {
        return 10.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public static void setPos(ItemStack stack, BlockPos pos, Direction face, Level world) {
        int index;
        ItemInventoryBase inv;
        ItemStack invStack;
        if (stack.m_41720_() == ItemInit.RUNE_MARKING.get()) {
            ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).setLocation(stack, pos, face, world);
        } else if (stack.m_41720_() == ItemInit.BOOK_MARKS.get() && (invStack = (inv = new ItemInventoryBase(stack)).getStackInSlot(index = ((BookOfMarks)ItemInit.BOOK_MARKS.get()).getIndex(stack))).m_41720_() == ItemInit.RUNE_MARKING.get()) {
            ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).setLocation(stack, pos, face, world);
        }
    }

    public boolean canBeChanneled() {
        return false;
    }
}

