/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.component;

import com.mna.api.affinity.Affinity;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.DamageHelper;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IDamageComponent;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.effects.EffectInit;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import de.joh.dmnr.common.util.RLoc;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ForceDamageComponent
extends SpellEffect
implements IDamageComponent {
    public ForceDamageComponent(ResourceLocation icon) {
        super(icon, new AttributeValuePair[]{new AttributeValuePair(Attribute.DAMAGE, 5.0f, 1.0f, 20.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.LESSER_MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.MAGNITUDE, 0.0f, 0.0f, 6.0f, 1.0f, 6.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Entity entity;
        if (target.isEntity() && (entity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            float damage = modificationData.getValue(Attribute.DAMAGE) * Math.max((float)GeneralConfigValues.GlobalDamageScale, 0.1f);
            float reduction = 1.0f - CombatRules.m_19272_((float)damage, (float)entity2.m_21230_(), (float)((float)entity2.m_21133_(Attributes.f_22285_))) / damage;
            target.getEntity().m_6469_(DamageHelper.createSourcedType(ForceDamageComponent.getForceDamage(), (RegistryAccess)context.getLevel().m_9598_(), (Entity)source.getCaster()), damage *= 1.0f - reduction + reduction * modificationData.getValue(Attribute.MAGNITUDE) / 3.0f);
            if (entity2 != source.getCaster()) {
                float speed = modificationData.getValue(Attribute.LESSER_MAGNITUDE) / 2.0f;
                float max_velocity = 2.0f;
                MobEffectInstance effect = entity2.m_21124_((MobEffect)EffectInit.ENLARGE.get());
                if (effect != null) {
                    speed = (float)((double)speed * (1.0 - 0.1 * (double)(effect.m_19564_() + 1)));
                    max_velocity *= 0.5f;
                }
                if ((effect = entity2.m_21124_((MobEffect)EffectInit.REDUCE.get())) != null) {
                    speed = (float)((double)speed * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
                    max_velocity = (float)((double)max_velocity * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
                }
                float mX = (float)(source.getOrigin().m_7096_() - target.getLivingEntity().m_20185_());
                float mZ = (float)(source.getOrigin().m_7094_() - target.getLivingEntity().m_20189_());
                if (source.getCaster().m_20202_() == entity2) {
                    mX = (float)(-source.getCaster().m_20156_().f_82479_);
                    mZ = (float)(-source.getCaster().m_20156_().f_82481_);
                }
                ForceDamageComponent.flingTarget(entity2, new Vec3((double)mX, (double)speed, (double)mZ), speed, max_velocity);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    public boolean targetsBlocks() {
        return false;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.EARTH;
    }

    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    public float initialComplexity() {
        return 10.0f;
    }

    public int requiredXPForRote() {
        return 500;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }

    public List<Affinity> getValidTinkerAffinities() {
        return List.of(Affinity.EARTH);
    }

    public static void flingTarget(LivingEntity target, Vec3 direction, float strength, float kbResistFactor) {
        float max_velocity = 2.0f;
        if (target != null) {
            MobEffectInstance effect = target.m_21124_((MobEffect)EffectInit.ENLARGE.get());
            if (effect != null) {
                strength = (float)((double)strength * (1.0 - 0.1 * (double)(effect.m_19564_() + 1)));
                max_velocity *= 0.5f;
            }
            if ((effect = target.m_21124_((MobEffect)EffectInit.REDUCE.get())) != null) {
                strength = (float)((double)strength * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
                max_velocity = (float)((double)max_velocity * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
            }
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                Vec3 motion = direction.m_82541_().m_82490_((double)strength);
                targetPlayer.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                motion = targetPlayer.m_20184_();
                if (motion.m_82553_() > (double)max_velocity) {
                    double scale = (double)max_velocity / motion.m_82553_();
                    targetPlayer.m_20256_(motion.m_82490_(scale));
                }
                targetPlayer.f_19864_ = true;
                ((ServerPlayer)targetPlayer).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)targetPlayer));
                if (!CuriosInterop.IsItemInCurioSlot((Item)((Item)ItemInit.AIR_CAST_RING.get()), (LivingEntity)targetPlayer, (SlotTypePreset)SlotTypePreset.RING)) {
                    ForceDamageComponent.setFlags((LivingEntity)targetPlayer, strength);
                }
            } else {
                LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)direction.f_82479_, (double)direction.f_82481_);
                if (!event.isCanceled()) {
                    double kbRes = target.m_21133_(Attributes.f_22278_);
                    strength = event.getStrength();
                    direction = new Vec3(event.getRatioX(), 0.0, event.getRatioZ());
                    if (!((double)(strength = (float)((double)strength * (1.0 - kbRes * (double)kbResistFactor))) <= 0.0)) {
                        target.f_19812_ = true;
                        Vec3 vec3 = target.m_20184_();
                        Vec3 vec31 = new Vec3(direction.f_82479_, 0.0, direction.f_82481_).m_82541_().m_82490_((double)strength);
                        target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, target.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + (double)strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                    }
                }
                target.m_5997_(0.0, (double)(0.2f * strength), 0.0);
                if (target instanceof PathfinderMob) {
                    ((PathfinderMob)target).m_21573_().m_26573_();
                }
                ForceDamageComponent.setFlags(target, strength);
            }
        }
    }

    private static void setFlags(LivingEntity le, float strength) {
        le.getPersistentData().m_128350_("mna:flung", strength);
        le.getPersistentData().m_128356_("mna:fling_time", le.m_9236_().m_46467_());
        le.f_19812_ = true;
    }

    public static ResourceKey<DamageType> getForceDamage() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)RLoc.create("spell_force"));
    }

    public static ResourceKey<DamageType> getRevengeDamage() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)RLoc.create("spell_revenge"));
    }
}

