/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.spell.component;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.IDelayedEvent;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.factions.Factions;
import com.mna.tools.TeleportHelper;
import de.joh.dmnr.api.util.MarkSave;
import de.joh.dmnr.common.util.CommonConfig;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class AlternativeRecallComponent
extends SpellEffect {
    public AlternativeRecallComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.RANGE, 1.0f, 1.0f, 5.0f, 1.0f, 25.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 5.0f, 1.0f, 10.0f), new AttributeValuePair(Attribute.PRECISION, 0.0f, 0.0f, 1.0f, 10.0f)});
    }

    public int requiredXPForRote() {
        return 200;
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Vec3 targetPosition = null;
        if (modificationData.getValue(Attribute.PRECISION) == 1.0f && target.getLivingEntity() != source.getCaster() && source.getCaster() != null && context.getServerLevel() != null) {
            if (target.getLivingEntity() != null) {
                float step = 1.5f;
                Vec3 delta = target.getLivingEntity().m_20156_().m_82541_().m_82490_((double)step);
                int tries = 0;
                do {
                    ++tries;
                    targetPosition = target.getLivingEntity().m_20182_().m_82546_(delta);
                    if (!(targetPosition.m_82554_(source.getCaster().m_20182_()) < (double)step)) continue;
                    source.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:components/blink.failed"));
                    return ComponentApplicationResult.FAIL;
                } while (tries <= 10 && !TeleportHelper.coordsValidForBlink((Level)context.getServerLevel(), (int)((int)targetPosition.m_7096_()), (int)((int)targetPosition.m_7098_()), (int)((int)targetPosition.m_7094_())));
                if (source.getPlayer() != null) {
                    Vec3 targetEye = target.getLivingEntity().m_146892_();
                    Player looker = source.getPlayer();
                    DelayedEventQueue.pushEvent((Level)context.getLevel(), (IDelayedEvent)new TimedDelayedEvent("look", 1, (Object)targetEye, (k, v) -> looker.m_7618_(EntityAnchorArgument.Anchor.EYES, targetEye)));
                }
            } else {
                if (!target.isBlock()) {
                    return ComponentApplicationResult.FAIL;
                }
                BlockPos check = target.getBlock().m_121955_(target.getBlockFace((SpellEffect)this).m_122436_());
                if (TeleportHelper.coordsValidForBlink((Level)context.getServerLevel(), (int)check.m_123341_(), (int)check.m_123342_(), (int)check.m_123343_())) {
                    targetPosition = Vec3.m_82539_((Vec3i)check);
                }
            }
            if (!this.isValidDistance(targetPosition, source.getCaster(), modificationData)) {
                if (source.getPlayer() != null) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:components/blink.toofar"));
                }
                return ComponentApplicationResult.FAIL;
            }
            if (!context.getServerLevel().m_5776_()) {
                EntityTeleportEvent tpEvent = new EntityTeleportEvent((Entity)source.getCaster(), targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
                if (!MinecraftForge.EVENT_BUS.post((Event)tpEvent)) {
                    source.getCaster().m_6021_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
                }
                return ComponentApplicationResult.SUCCESS;
            }
            return ComponentApplicationResult.FAIL;
        }
        if (target.getLivingEntity() != null && source.getCaster() != null && target.getLivingEntity().m_6072_()) {
            MarkSave markSave = MarkSave.getMark(source.getCaster(), source.getCaster().m_20193_(), (Boolean)CommonConfig.RECALL_SUPPORT_PLAYERCHARM.get());
            if (markSave != null && markSave.getPosition() != null) {
                targetPosition = markSave.getPosition().m_252807_();
                if (this.isValidDistance(targetPosition, target.getLivingEntity(), modificationData)) {
                    if (target.getLivingEntity() == source.getCaster() || this.magnitudeHealthCheck(source, target, (int)modificationData.getValue(Attribute.MAGNITUDE), 20)) {
                        TeleportHelper.teleportEntity((Entity)target.getLivingEntity(), (ResourceKey)context.getLevel().m_46472_(), (Vec3)new Vec3(targetPosition.f_82479_, targetPosition.f_82480_ + 1.0, targetPosition.f_82481_));
                        return ComponentApplicationResult.SUCCESS;
                    }
                    if (source.getPlayer() != null) {
                        source.getPlayer().m_5661_((Component)Component.m_237115_((String)"mna:generic.too_powerful"), true);
                    }
                    return ComponentApplicationResult.FAIL;
                }
                if (source.getPlayer() != null) {
                    source.getPlayer().m_5661_((Component)Component.m_237115_((String)"mna:components/recall.too_far"), true);
                }
            } else if (source.getPlayer() != null) {
                source.getPlayer().m_5661_((Component)Component.m_237115_((String)"dmnr.shapes.atmark.nomark.error"), true);
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    private boolean isValidDistance(@Nullable Vec3 targetPosition, @NotNull LivingEntity caster, @NotNull IModifiedSpellPart<SpellEffect> modificationData) {
        if (targetPosition == null) {
            return false;
        }
        if (((Boolean)CommonConfig.RECALL_UNLIMITED_RANGE.get()).booleanValue() && modificationData.getValue(Attribute.RANGE) >= modificationData.getMaximumValue(Attribute.RANGE)) {
            return true;
        }
        return !(targetPosition.m_82554_(caster.m_20182_()) > (double)(modificationData.getValue(Attribute.RANGE) * 1000.0f));
    }

    public boolean targetsBlocks() {
        return true;
    }

    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    public IFaction getFactionRequirement() {
        return Factions.COUNCIL;
    }

    public float initialComplexity() {
        return 50.0f;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

