/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.ritual;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import de.joh.dmnr.api.event.DragonUpgradeEvent;
import de.joh.dmnr.api.event.HasMaxFactionEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DragonMageArmorRitual
extends RitualEffect {
    public DragonMageArmorRitual(ResourceLocation ritualName) {
        super(ritualName);
    }

    protected boolean applyRitualEffect(IRitualContext context) {
        Player player = context.getCaster();
        Level world = context.getLevel();
        BlockPos pos = context.getCenter();
        HasMaxFactionEvent factionEvent = new HasMaxFactionEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)factionEvent);
        DragonUpgradeEvent event = new DragonUpgradeEvent(context.getCaster(), factionEvent.getTargetFaction());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.canBeUpgraded()) {
            event.performUpgrade(true);
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningbolt.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)lightningbolt);
            return true;
        }
        return false;
    }

    public boolean applyStartCheckInCreative() {
        return true;
    }

    public Component canRitualStart(IRitualContext context) {
        Player player = context.getCaster();
        HasMaxFactionEvent event = new HasMaxFactionEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.hasMaxFactionArmor()) {
            return Component.m_237115_((String)"dmnr.ritual.output.dragonmagearmorritual.wrong.armor.error");
        }
        boolean[] isLevel75 = new boolean[]{false};
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            isLevel75[0] = 75 <= m.getMagicLevel();
        });
        return isLevel75[0] ? null : Component.m_237115_((String)"dmnr.ritual.output.dragonmagearmorritual.to.low.level.error");
    }

    protected int getApplicationTicks(IRitualContext iRitualContext) {
        return 0;
    }
}

