/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item.spellstoring;

import com.mna.api.items.ITieredItem;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.parts.Shape;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.inventory.InventoryRitualKit;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.base.IItemWithGui;
import com.mna.items.ritual.PractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import de.joh.dmnr.common.init.ItemInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public abstract class RingOfSpellStoringItem
extends Item
implements ITieredItem<RingOfSpellStoringItem>,
IItemWithGui<RingOfSpellStoringItem> {
    private int _tier = -1;

    public RingOfSpellStoringItem(Item.Properties itemProperties) {
        super(itemProperties);
    }

    public static void castSpell(@NotNull Player caster) {
        List rings = CuriosApi.getCuriosHelper().findCurios((LivingEntity)caster, (Item)ItemInit.RING_OF_SPELL_STORING.get());
        if (rings.isEmpty()) {
            rings = CuriosApi.getCuriosHelper().findCurios((LivingEntity)caster, (Item)ItemInit.RING_OF_SPELL_STORING_COOLDOWN.get());
        }
        if (!rings.isEmpty()) {
            ItemStack ring = ((SlotResult)rings.get(0)).stack();
            Item item = ring.m_41720_();
            if (item instanceof RingOfSpellStoringItem) {
                SpellRecipe recipe;
                RingOfSpellStoringItem ringOfSpellStoring = (RingOfSpellStoringItem)item;
                ItemInventoryBase inv = new ItemInventoryBase(ring);
                ItemStack slot = inv.getStackInSlot(0);
                if (slot.m_41720_() != com.mna.items.ItemInit.ENCHANTED_VELLUM.get() && !slot.m_41619_() && SpellRecipe.stackContainsSpell((ItemStack)slot) && !caster.m_9236_().f_46443_ && (recipe = SpellRecipe.fromNBT((CompoundTag)slot.m_41783_())).isValid() && ringOfSpellStoring.canUse(caster, ring, recipe)) {
                    if (!((Shape)recipe.getShape().getPart()).isChanneled()) {
                        List<Map.Entry> missingRequired;
                        HashMap<Item, Boolean> missing = RingOfSpellStoringItem.checkReagents(caster, recipe);
                        if (!caster.m_7500_() && !(missingRequired = missing.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).toList()).isEmpty()) {
                            if (!caster.m_9236_().f_46443_) {
                                if (missing.size() > 1) {
                                    caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.reagents-missing.multi"));
                                } else {
                                    caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.reagents-missing.single").m_7220_((Component)Component.m_237115_((String)((Item)missingRequired.get(0).getKey()).m_5524_())));
                                }
                            }
                            return;
                        }
                        ItemSpell.castSpellOnUse((ItemStack)slot, (Level)caster.m_9236_(), (Player)caster, (InteractionHand)InteractionHand.MAIN_HAND, itemStack -> false);
                        ringOfSpellStoring.onUse(caster, ring, recipe);
                    } else {
                        caster.m_5661_((Component)Component.m_237115_((String)"dmnr.ring_of_spell_storing.no_channeled.error"), true);
                    }
                }
            }
        } else {
            caster.m_5661_((Component)Component.m_237115_((String)"dmnr.ring_of_spell_storing.no_ring.error"), true);
        }
    }

    private static HashMap<Item, Boolean> checkReagents(Player caster, SpellRecipe recipe) {
        HashMap<Item, Boolean> missing = new HashMap<Item, Boolean>();
        if (caster.m_7500_()) {
            return missing;
        }
        List<Pair<IItemHandler, Direction>> inventories = RingOfSpellStoringItem.getReagentSearchInventories(caster);
        for (SpellReagent reagent : recipe.getReagents(caster, null, null)) {
            if (InventoryUtilities.consumeAcrossInventories((ItemStack)reagent.getReagentStack(), (boolean)reagent.getIgnoreDurability(), (boolean)reagent.getCompareNBT(), (boolean)true, inventories)) continue;
            missing.put(reagent.getReagentStack().m_41720_(), reagent.getOptional());
        }
        if (missing.isEmpty()) {
            for (SpellReagent reagent : recipe.getReagents(caster, null, null)) {
                InventoryUtilities.consumeAcrossInventories((ItemStack)reagent.getReagentStack(), (boolean)reagent.getIgnoreDurability(), (boolean)reagent.getCompareNBT(), (boolean)false, inventories);
            }
        }
        return missing;
    }

    private static List<Pair<IItemHandler, Direction>> getReagentSearchInventories(Player caster) {
        ArrayList<Pair<IItemHandler, Direction>> output = new ArrayList<Pair<IItemHandler, Direction>>();
        for (int i = 0; i < caster.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = caster.m_150109_().m_8020_(i);
            if (invStack.m_41619_() || !(invStack.m_41720_() instanceof PractitionersPouch)) continue;
            PractitionersPouch item = (PractitionersPouch)invStack.m_41720_();
            Pair remoteInv = item.resolveRemoteInventory(invStack, caster.m_9236_());
            if (remoteInv.getFirst() != null) {
                output.add((Pair<IItemHandler, Direction>)remoteInv);
            }
            if (item.getPatchLevel(invStack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> output.add(new Pair((Object)new InvWrapper((Container)m.getRiftInventory()), (Object)Direction.UP)));
            }
            InventoryRitualKit kit = new InventoryRitualKit(invStack);
            output.add((Pair<IItemHandler, Direction>)new Pair((Object)kit, (Object)Direction.UP));
        }
        output.add(new Pair((Object)new InvWrapper((Container)caster.m_150109_()), (Object)Direction.UP));
        return output;
    }

    protected abstract boolean canUse(Player var1, ItemStack var2, SpellRecipe var3);

    protected abstract void onUse(Player var1, ItemStack var2, SpellRecipe var3);

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!world.f_46443_ && this.openGuiIfModifierPressed(held, player, world)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nullable ItemStack itemStack) {
        return true;
    }

    public int getCachedTier() {
        return this._tier;
    }

    public void setCachedTier(int tier) {
        this._tier = tier;
    }
}

